/*=======================================================================
=                           INCLUDE FILES                               =
=======================================================================*/

#include    <stdlib.h>
#include    <mem.h>
#include    <stdio.h>
#include 	<dos.h>
#include 	"mvidf1fd.h"
#include 	"ktypes.h"
#include    "system.h"
#include    "kernel.h"
/*=======================================================================
=                       MAIN ENTRY POINT                                =
=======================================================================*/

/************************************************************************
*
*     Entry point:                                                      
*       main                                           
*
*     Description:                                                      
*		This is a sample program for the Full-Duplex DF1 API.  This program
*		performs the following functions:
*			1. Fetches and displays the series and revision number of
*				the full-duplex DF1 API. 
*			2. Opens a full-duplex DF1 engine on Port 3
*			3. Transmits an ECHO command to a receiving full-duplex DF1
*				remote port.
*			4. Verifies proper transmission of the ECHO command
*			5. Monitors for a response packet to the ECHO command
*			6. Closes the full-duplex DF1 engine running on Port 3.  
*     Arguments:                                                        
*       none
*
*     External effects:                                                 
*
*
*     Return value:                                                     
*       none
*
*-----------------------------------------------------------------------
*     Notes:                                                            
*
*
************************************************************************/
void main(void)
{
FDCFG Port3Cfg;           		// Allocate data for port 3	DF1 configuration

BYTE DF1_Resp_Pkt[256];
BYTE DF1_Source_Pkt[256];
WORD Pkt_Len;
WORD i;
SRCXMT DF1_Stat;
RSPRCV DF1_Resp_Stat;
MVIFDVERSIONINFO verinfo;

int rc;
	Port3Cfg.Baud = BAUD_9600;
	Port3Cfg.Parity = PARITY_NONE;
	Port3Cfg.Stop = STOPBITS1;
	Port3Cfg.DupPacket = DUP_PACKET_DIS;
	Port3Cfg.ErrorDet = CRC_ERROR_CHK;
	Port3Cfg.Station = 0x12;
	Port3Cfg.Max_NAKS = 0x03;
	Port3Cfg.Max_ENQS = 0x03;
	Port3Cfg.Handshake = HSHAKE_NONE;
	Port3Cfg.RTSSend = 70;
	Port3Cfg.RTSOff = 40;
	Port3Cfg.ACKTimeout = 500;
	Port3Cfg.MsgApplTimeout = 30;
	Port3Cfg.ComPort = COM3;
	rc = MVIdf1_FDOpenPort(&Port3Cfg);
	if(rc == MVI_SUCCESS)
	{
    	printf("\nPort opened successfully\n");
		if(MVI_SUCCESS == MVIdf1_FDGetVersionInfo(&verinfo))
		{
			printf("\nLibrary Series %d, Rev %d\n", verinfo.APISeries, verinfo.APIRevision);
		}
		else
		{
			printf("\nVersion information retrieval failed\n");
		}
						// Build command packet
			i = 0x00;
			DF1_Source_Pkt[i++] = 0x80;		//DST
			DF1_Source_Pkt[i++] = Port3Cfg.Station;	//SRC
			DF1_Source_Pkt[i++] = 0x06;		//CMD
			DF1_Source_Pkt[i++] = 0x00;		//STS
			DF1_Source_Pkt[i++] = 0x06;		//TNS MSB
			DF1_Source_Pkt[i++] = 0x01;		//TNS LSB
			DF1_Source_Pkt[i++] = 0x00;		//FNC
			DF1_Source_Pkt[i++] = 0x55;		//DATA
			DF1_Source_Pkt[i++] = 0xAA;		//DATA
			DF1_Source_Pkt[i++] = 0x01;
			DF1_Source_Pkt[i++] = 0x02;
			DF1_Source_Pkt[i++] = 0x03;
			DF1_Source_Pkt[i++] = 0x04;
			DF1_Source_Pkt[i++] = 0x05;
			DF1_Source_Pkt[i++] = 0x06;
			DF1_Source_Pkt[i++] = 0xFF;
			Pkt_Len = i;
			if(0x00 == (MVIdf1_FDPutPkt(COM3,DF1_Source_Pkt,&Pkt_Len)))
			{
				printf("\nCommand packet queued for transmission\n");
				printf("\nMonitoring transmission status\n");
				while(MVI_ERR_NOSTAT == MVIdf1_FDGetPktStat(COM3,&DF1_Stat))
				{};
				while(MVIDF1_XMITTING == DF1_Stat.XmitStatus)
				{
					if(MVI_SUCCESS != MVIdf1_FDGetPktStat(COM3,&DF1_Stat))
					{					// Status retrieval failed
						printf("\nPacket status retrieval error !\n");
									// Force exit
						DF1_Stat.XmitStatus = MVIDF1_FAILED;
					}
				}
				if(DF1_Stat.XmitStatus == MVIDF1_SUCCESS)
				{
					printf("\nPacket transmission successful\n");
					printf("\nWaiting for packet\n");
					while(MVI_ERR_NODATA == MVIdf1_FDGetPkt(COM3,
							DF1_Resp_Pkt,&Pkt_Len,&DF1_Resp_Stat))
					{}
					if(DF1_Resp_Stat.RespStatus == MVI_RESP_VALID)
					{
						printf("\nPacket received\n");
					}
					else
					{
						if(DF1_Resp_Stat.RespStatus == MVI_RESP_TIMEOUT)
						{
							printf("\nPacket not received\n");
							printf("\nPacket timeout exceeded\n");
						}
					}
				}
				else
				{
					printf("\nPacket transmission failed\n");
				}	 
			}
	}
	if(MVI_SUCCESS != MVIdf1_FDClosePort(COM3))	// Terminate the thread
	{
		printf("Port closure error \n");
	}
	exit(0);
}
