;***	FCE.INC -- Embedded DOS FAT Cache Entry.
;
;1.	Functional Description.
;	This structure defines the layout of a FAT FSD Cache Entry, a block
;	of storage that is linked up into a list of objects that represent
;	sectors that have had recent small I/O activity in the FAT FSD.
;
;	We cache 512-byte sectors when the FAT FSD needs to read a small
;	piece of data (such as a FAT entry, or a few bytes from a file),
;	so that the remainder of the sector could be available for the
;	next access to the same sector, without another real disk I/O
;	being necessary.
;
;	The cache grows and shrinks dynamically as the system runs.  As
;	sectors get cached, a variable in the FAT FSD counts down the maximum
;	allocatable cache buffers so that system pool is not exhausted.  The
;	file system periodically (every few seconds) runs a thread from a
;	timer expiration to age the cache and return valuable system pool.
;
;2.	Modification History.
;	S. E. Jones	91/01/13.	Built file system cache.
;	S. E. Jones	91/01/29.	Changed definition of fce_ttl.
;	S. E. Jones	92/01/09.	#1.095, changed fce_ttl to ms, not runs.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;	S. E. Jones	96/04/09.	#6-XL v46, added quota override.
;
;3.	NOTICE: Copyright (C) 1990-1996 General Software, Inc.

FCE		struc
fce_fwdlink	dw	?		; ofs FWA, next FCE in DOSDATA.
fce_flags	dw	?		; bitflags, defined below.
fce_sdte	dw	?		; SDTE for device containing sector.
fce_ttl         dw	?		; time to live, this entry (ms).
fce_hits	dw	?		; hit count (in-cache lookups).
fce_lsn         dd	?		; partition-relative sector number.
fce_buffer	db	(DISK_BLOCK_SIZE) dup (?) ; the sector buffer itself.
FCE		ends

FCE_FLAGS_DIRTY =	0001h		; sector is dirty (will be lazy-written.)
FCE_FLAGS_ERROR =	0002h		; error during lazy write (data good.)
FCE_FLAGS_QUOTA_OVERRIDE = 0004h	; this FCE not applied to quota limit.
