;***	386.INC -- Intel '386 Feature Definitions.
;
;1.	Functional Description.
;	This file contains bitflag and structure definitions for the
;	386, 486, and Pentium CPUs' protected mode features.
;
;2.	Modification History.
;	S. E. Jones	95/01/17.	Original for EMM386.
;	D. K. Gibson	96/06/05.	Add IOPL values.
;
;3.	NOTICE: Copyright (C) 1995 General Software, Inc.

	.386p

;	The following defines the layout of the EFLAGS register.

EFLAGS_CF	=	00000001h	; CY flag.
EFLAGS_1	=	00000002h	; reserved, MUST BE 1.
EFLAGS_PF	=	00000004h	; parity flag.
EFLAGS_RESV1	=	00000008h	; reserved, must be 0.
EFLAGS_AF	=	00000010h	; aux flag.
EFLAGS_RESV2	=	00000020h	; reserved, must be 0.
EFLAGS_ZF	=	00000040h	; zero flag.
EFLAGS_SF	=	00000080h	; sign flag.
EFLAGS_TF	=	00000100h	; trap flag.
EFLAGS_IF	=	00000200h	; interrupt flag.
EFLAGS_DF	=	00000400h	; direction flag.
EFLAGS_OF	=	00000800h	; overflow flag.
EFLAGS_IOPL0	=	00000000h	; IOPL 0 value.
EFLAGS_IOPL1	=	00001000h	; IOPL 1 value / bit.
EFLAGS_IOPL2	=	00002000h	; IOPL 2 value / bit.
EFLAGS_IOPL3	=	00003000h	; IOPL 3 value.
EFLAGS_NF	=	00004000h	; nested task.
EFLAGS_RESV3	=	00008000h	; reserved, must be 0.
EFLAGS_RF	=	00010000h	; resume flag.
EFLAGS_VM	=	00020000h	; virtual 86 mode.
EFLAGS_AC	=	00040000h	; alignment check.
EFLAGS_VIF	=	00080000h	; virtual interrupt flag (Pentium only).
EFLAGS_VIP	=	00100000h	; virtual int pending (Pentium only).
EFLAGS_ID	=	00200000h	; CPUID instruction supported.

;	The following defines the layout of the CR0 register.

CR0_PE		=	00000001h	; protected mode enable.
CR0_MP		=	00000002h	;
CR0_EM		=	00000004h	;
CR0_TS		=	00000008h	; task switched.
CR0_ET		=	00000010h	; extension type (on Pentium, reserved).
CR0_NE		=	00000020h	; numeric error.
CR0_WP		=	00010000h	; write-prot user pgs against supv level.
CR0_AM		=	00040000h	; alignment checking.
CR0_NW		=	20000000h	; not write-through cache.
CR0_CD		=	40000000h	; cache disable.
CR0_PG		=	80000000h	; enable paging.

;	The CR2 register contains the page fault linear address when
;	a page fault occurs.  This value is a 32-bit linear address.


;	The following defines the layout of the CR3 register.

CR3_PWT         =	00000008h	; page-level writes transparent (Pentium).
CR3_PCD         =	00000010h	; page-level cache disable (Pentium).
CR3_FLAG_MASK	=	00000fffh	; bottom 12 bits (flags as above).
CR3_PAGEDIR	=	not CR3_FLAG_MASK  ; top 20 bits (pg dir base).

;	The following defines the layout of the CR4 register (Pentium only).

CR4_VME         =	00000001h	; Pentium: V86 mode extensions.
CR4_PVI         =	00000002h	; Pentium: P/M virtual interrupts.
CR4_TSD         =	00000004h	; Pentium: time stamp disable.
CR4_DE		=	00000008h	; Pentium: debugging extensions.
CR4_PSE         =	00000010h	; Pentium: page size extensions.
CR4_MCE         =	00000040h	; Pentium: machine check enable.

;	The following defines the layout of a page directory entry.

PDE_PRESENT	=	00000001h	; the present bit.
PDE_WRITABLE	=	00000002h	; page is writable.
PDE_USER	=	00000004h	; page is user-mode.
PDE_WRITE_THRU	=	00000008h	; write-through mode.
PDE_DISAB_CACHE =	00000010h	; cache disabled.
PDE_ACCESSED	=	00000020h	; directory has been accessed.
PDE_RESERVED1	=	00000040h	; reserved, must be 0.
PDE_HUGE_PAGE	=	00000080h	; set indicates 4MB pages; clr = 4KB.
PDE_RESERVED2	=	00000100h	; reserved, must be 0.
PDE_FLAG1	=	00000200h	; available for system program use.
PDE_FLAG2	=	00000400h	; available for system program use.
PDE_FLAG3	=	00000800h	; available for system program use.
PDE_FLAG_MASK	=	00000fffh	; keeps flags.
PDE_FRAME_MASK	=	not PDE_FLAG_MASK  ; keeps page frame address 31..12.

;	The following defines the layout of a page table entry.

PTE_PRESENT	=	00000001h	; the present bit.
PTE_WRITABLE	=	00000002h	; page is writable.
PTE_USER	=	00000004h	; page is user-mode.
PTE_WRITE_THRU	=	00000008h	; write-through mode.
PTE_DISAB_CACHE =	00000010h	; cache disabled.
PTE_ACCESSED	=	00000020h	; directory has been accessed.
PTE_DIRTY	=	00000040h	; page has been written to.
PTE_RESERVED1	=	00000080h	; reserved, must be 0.
PTE_RESERVED2	=	00000100h	; reserved, must be 0.
PTE_FLAG1	=	00000200h	; available for system program use.
PTE_FLAG2	=	00000400h	; available for system program use.
PTE_FLAG3	=	00000800h	; available for system program use.
PTE_FLAG_MASK	=	00000fffh	; keeps flags.
PTE_FRAME_MASK	=	not PTE_FLAG_MASK  ; keeps page frame address 31..12.

	.8086
