////////////////////////////////////////////////////////////////////////////////
//
//
////////////////////////////////////////////////////////////////////////////////



#ifndef _wattcp_wattcp_h
#define _wattcp_wattcp_h

/*
 * Are we compiling the kernel?
 *    or an application using the kernel?
 */
#if !defined(__WATTCP_USER__)
#define __WATTCP_KERNEL__
#endif

/*
 * Note that some stuff is not available to user applications.
 *   This is generally detail you shouldn't need to worry about,
 *   and best stay away from to preserve the kernel integrity.
 * Note also that there is a lot of other stuff that should probably
 *   be protected but isn't.
 */

#define WATTCPH

/* these are visible for select.c routine return values */
#define SOCKESTABLISHED 1
#define SOCKDATAREADY   2
#define SOCKCLOSED      4

#if defined(__WATTCP_KERNEL__)

# define IP_TYPE     0x0008

/*
#define DEBUG
*/

# include <stdio.h>

# define MAX_GATE_DATA 12
# define MAX_STRING    50	/* most strings are limited */
#endif  /* defined(__WATTCP_KERNEL__) */


#if defined(__WATTCP_KERNEL__)

#define MAXVJSA     1440 /* 10 s */
#define MAXVJSD     360  /* 10 s */
#define SAFETYTCP  0x538f25a3L
#define SAFETYUDP  0x3e45e154L
#define TRUE        1
#define true        TRUE
#define FALSE       0
#define false       FALSE

#define EL_INUSE        0x0001
#define EL_DELAY        0x0002
#define EL_TCP          0x0004
#define EL_SERVER       0x0008
#define EL_ASCII        0x0010
#define EL_NEVER        0x0020

/* These are Ethernet protocol numbers but I use them for other things too */
#define UDP_PROTO  0x11
#define TCP_PROTO  0x06
#define ICMP_PROTO 0x01

#endif /* defined(__WATTCP_KERNEL__) */

#define TCP_MODE_BINARY  0       /* default mode */
#define TCP_MODE_ASCII   1
#define UDP_MODE_CHK     0       /* default to having checksums */
#define UDP_MODE_NOCHK   2       /* turn off checksums */
#define TCP_MODE_NAGLE   0       /* Nagle algorithm */
#define TCP_MODE_NONAGLE 4

typedef unsigned long longword;     /* 32 bits */
typedef unsigned short word;        /* 16 bits */
typedef unsigned char byte;         /*  8 bits */

typedef struct { byte eaddr[6]; } eth_address;    // 94.11.19 -- made an array

#if defined(__WATTCP_KERNEL__)

/* undesirable */
extern longword MsecClock();
#define clock_ValueRough() MsecClock()

#define TICKS_SEC 18

#define checksum( p, len) inchksum( p, len )

#define PD_ETHER 1
#define PD_SLIP  6

extern word sock_inactive;
extern word _pktdevclass;
extern word _mss;


/* The Ethernet header */
typedef struct {
    eth_address     destination;
    eth_address     source;
    word            type;
} eth_Header;

/* The Internet Header: */
typedef struct {
    unsigned	    hdrlen  : 4;
    unsigned	    ver     : 4;
    byte	    tos;
    word            length;
    word            identification;
    word            frags;
    byte	    ttl;
    byte	    proto;
    word            checksum;
    longword        source;
    longword        destination;
} in_Header;


typedef struct {
    word	    srcPort;
    word	    dstPort;
    word	    length;
    word	    checksum;
} udp_Header;

#define UDP_LENGTH ( sizeof( udp_Header ))

typedef struct {
    word            srcPort;
    word            dstPort;
    longword        seqnum;
    longword        acknum;
    word            flags;
    word            window;
    word            checksum;
    word            urgentPointer;
} tcp_Header;

#define tcp_FlagFIN     0x0001
#define tcp_FlagSYN     0x0002
#define tcp_FlagRST     0x0004
#define tcp_FlagPUSH    0x0008
#define tcp_FlagACK     0x0010
#define tcp_FlagURG     0x0020
#define tcp_FlagDO      0xF000

#endif /* defined(__WATTCP_KERNEL__)

/* The TCP/UDP Pseudo Header */
typedef struct {
	longword    src;
    longword    dst;
    byte        mbz;
    byte        protocol;
    word        length;
    word        checksum;
} tcp_PseudoHeader;


/* A datahandler for tcp or udp sockets */
typedef int (*dataHandler_t)( void *s, byte *data, int len, tcp_PseudoHeader *pseudohdr, void *protohdr );
/* A socket function for delay routines */
typedef int (*sockfunct_t)( void *s );

#if defined(__WATTCP_KERNEL__)
/*
 * TCP states, from tcp manual.
 * Note: close-wait state is bypassed by automatically closing a connection
 *       when a FIN is received.  This is easy to undo.
 */
#define tcp_StateLISTEN    0      /* listening for connection */
#define tcp_StateSYNSENT   1      /* syn sent, active open */
#define tcp_StateSYNREC    2      /* syn received, synack+syn sent. */
#define tcp_StateESTAB     3      /* established */
#define tcp_StateESTCL     4      /* established, but will FIN */
#define tcp_StateFINWT1    5      /* sent FIN */
#define tcp_StateFINWT2    6      /* sent FIN, received FINACK */
#define tcp_StateCLOSWT    7      /* received FIN waiting for close */
#define tcp_StateCLOSING   8      /* sent FIN, received FIN (waiting for FINACK) */
#define tcp_StateLASTACK   9      /* fin received, finack+fin sent */
#define tcp_StateTIMEWT   10      /* dally after sending final FINACK */
#define tcp_StateCLOSEMSL 11
#define tcp_StateCLOSED   12      /* finack received */
#define tcp_StatePENDFIN  13      /* wait to send FIN until all data read */ //RAR 09/17/2003

#define tcp_MaxBufSize 2048       /* maximum bytes to buffer on input */

#endif


#if defined(__WATTCP_KERNEL__)
/*
 * UDP socket definition
 */
typedef struct _udp_socket {
	struct _udp_socket *next;
    word	    ip_type;		/* always set to UDP_PROTO */
    char	   *err_msg;		/* null when all is ok */
    char           *usr_name;
    void	  (*usr_yield)( void );
    byte            rigid;
    byte            stress;
    word	    sock_mode;	        /* a logical OR of bits */
    longword	    usertimer;		/* ip_timer_set, ip_timer_timeout */
    dataHandler_t  dataHandler;
    eth_address     hisethaddr;		/* peer's ethernet address */
   longword        hisaddr;		/* peer's internet address */
    word	    hisport;		/* peer's UDP port */
    longword        myaddr;
    word	    myport;
    word            locflags;

    int             queuelen;
    byte           *queue;

    int             rdatalen;           /* must be signed */
    word            maxrdatalen;
    byte           *rdata;
    byte            rddata[ tcp_MaxBufSize + 1];         /* if dataHandler = 0, len == 512 */
    longword        safetysig;
} udp_Socket;
#else /* __WATTCP_USER */
/*
 * Don't give users access to the fields.
 */
typedef struct {
    byte undoc[ 2200 ];
} udp_Socket;
#endif /* __WATTCP_USER__ */

#if defined(__WATTCP_KERNEL__)
/*
 * TCP Socket definition
 */
typedef struct _tcp_socket {
    struct _tcp_socket *next;
    word	    ip_type;	    /* always set to TCP_PROTO */
    char 	   *err_msg;
    char           *usr_name;
	void          (*usr_yield)(void);
    byte            rigid;
    byte            stress;
    word	    sock_mode;	    /* a logical OR of bits */

    longword	    usertimer;	    /* ip_timer_set, ip_timer_timeout */
    dataHandler_t   dataHandler;    /* called with incoming data */
    eth_address     hisethaddr;     /* ethernet address of peer */
    longword        hisaddr;        /* internet address of peer */
    word            hisport;	    /* tcp ports for this connection */
    longword        myaddr;
    word	    myport;
    word            locflags;

    int             queuelen;
    byte           *queue;

    int             rdatalen;       /* must be signed */
    word            maxrdatalen;
    byte           *rdata;
    byte            rddata[tcp_MaxBufSize+1];    /* received data */
    longword        safetysig;
    word	    state;          /* connection state */

    longword        acknum;
    longword	    seqnum; 	    /* data ack'd and sequence num */
    long            timeout;        /* timeout, in milliseconds */
    byte            unhappy;        /* flag, indicates retransmitting segt's */
    byte            recent;         /* 1 if recently transmitted */
    word            flags;          /* tcp flags word for last packet sent */

    word	    window;	    /* other guy's window */
    int 	    datalen;        /* number of bytes of data to send */
				    /* must be signed */
    int             unacked;        /* unacked data */

    byte	    cwindow;	    /* Van Jacobson's algorithm */
    byte	    wwindow;

    word	    vj_sa;	    /* VJ's alg, standard average */
    word	    vj_sd;	    /* VJ's alg, standard deviation */
    longword	    vj_last;	    /* last transmit time */
    word	    rto;
    byte	    karn_count;	    /* count of packets */
	byte            tos;            /* priority */
    /* retransmission timeout proceedure */
    /* these are in clock ticks */
    longword        rtt_lasttran;       /* last transmission time */
    longword        rtt_smooth;         /* smoothed round trip time */
    longword        rtt_delay;          /* delay for next transmission */
    longword        rtt_time;           /* time of next transmission */

    word            mss;
    longword        inactive_to;           /* for the inactive flag */
    int             sock_delay;

    byte            data[tcp_MaxBufSize+1]; /* data to send */
} tcp_Socket;
#else /* __WATTCP_USER */
/*
 * Don't give users access to the fields.
 */
typedef struct {
    byte undoc[ 4300 ];
} tcp_Socket;
#endif /* __WATTCP_USER__ */

#if defined(__WATTCP_KERNEL__)
/* sock_type used for socket io */
typedef union {
    udp_Socket udp;
    tcp_Socket tcp;
} sock_type;
#else /* __WATTCP_USER__ */
typedef void sock_type;
#endif /* __WATTCP_USER__ */

/* similar to UNIX */
typedef struct sockaddr {
    word        s_type;
    word        s_port;
    longword    s_ip;
    byte        s_spares[6];    /* unused in TCP realm */
};
#define sockaddr_in sockaddr

        /*
         * TCP/IP system variables - do not change these since they
		 *      are not necessarily the source variables, instead use
         *      ip_Init function
         */
extern longword my_ip_addr;
extern longword sin_mask;       /* eg.  0xfffffe00L */
extern word sock_delay;

#if defined(__WATTCP_KERNEL__)
extern eth_address _eth_addr;
extern eth_address _eth_brdcast;
#endif


#if defined(__WATTCP_KERNEL__)
/*
 * ARP definitions
 */
#define arp_TypeEther  0x100		/* ARP type of Ethernet address */

/* arp op codes */
#define ARP_REQUEST 0x0100
#define ARP_REPLY   0x0200

/*
 * Arp header
 */
typedef struct {
    word            hwType;
    word            protType;
    word            hwProtAddrLen;  // hw and prot addr len
    word            opcode;
    eth_address     srcEthAddr;
    longword        srcIPAddr;
    eth_address     dstEthAddr;
    longword        dstIPAddr;
} arp_Header;

#define ETH_MSS 1400  // MSS for Ethernet

#endif



/*
 * timers --
 */
void ip_timer_init( sock_type *s, int delayseconds );
int ip_timer_expired( sock_type *s );


/*
 * sock_init()  -- initialize wattcp libraries -- sock_ini.c
 */
void sock_init(void);
void sock_exit( void );   /* normally called via atexit() in sock_init() */


        /*
         * tcp_tick - called periodically by user application in sock_wait_...
         *          - returns 1 when our socket closes
         */
int tcp_tick( sock_type *s );


/*
 * Timeout routines.
 */
unsigned long set_timeout( unsigned int seconds );
int chk_timeout( unsigned long timeout );


/*
 * TCP or UDP specific stuff, must be used for open's and listens, but
 * sock stuff is used for everything else
 */
int tcp_open( tcp_Socket *s, word lport, longword ina, word port, dataHandler_t datahandler );
int udp_open( udp_Socket *s, word lport, longword ina, word port, dataHandler_t datahandler );
int tcp_open_fast( tcp_Socket *s, word lport, longword ina, word port, dataHandler_t datahandler );
int udp_open_fast( udp_Socket *s, word lport, longword ina, word port, dataHandler_t datahandler );
int tcp_listen( tcp_Socket *s, word lport, longword ina, word port, dataHandler_t datahandler, word timeout );

/*
 * Clean up a string
 */
char *rip( char *s);

/*
 * Name service / name lookup routines
 */
longword resolve( char *name );


/*
 * pcbsd.c
 */
char *inet_ntoa( char *s, longword x );
longword inet_addr( char *s );
char *sockerr( sock_type *s );
char *sockstate( sock_type *s );
longword gethostid( void );
word ntohs( word a );
word htons( word a );
longword ntohl( longword x );
longword htonl( longword x );


/*
 * General socket I/O
 */
word sock_mode( sock_type *, word);        /* see TCP_MODE_... */
void sock_abort( sock_type *);
int sock_fastwrite( sock_type *, byte *, int );
int sock_write( sock_type *, byte *, int );
int sock_read( sock_type *, byte *, int );
int sock_fastread( sock_type *, byte *, int );
int sock_gets( sock_type *, byte *, int );
void sock_close( sock_type *s );

byte sock_putc( sock_type  *s, byte c );
int sock_getc( sock_type  *s );
int sock_puts( sock_type  *s, byte *dp );


/*
 * Misc. socket I/O -- pctcp.c
 */
void sock_flush( sock_type  *s );
void sock_flushnext( sock_type  *s);
int sock_dataready( sock_type  *s );
int sock_established( sock_type *s );



#endif /* ndef _wattcp_wattcp_h */
