/*---------------------------------------------------------------------------
**
**	MAIN_APP.C
**
**
**	(c) 1999-2000, Vital Computer Solutions, All Rights Reserved
**	Richard A. Reynolds
**
**	Copyright (c) 2000-2006, ProSoft Technology, All Rights Reserved
**	Ken D. Hopwood
**
**	(c) 2002-2003, ProSoft Technology, All Rights Reserved
**	Sukhum Amorntrakul (Joe)
**
**	Incorporates code from 09/1999 to 11/2000
**
**	MODIFIED :
**
**		11/16/2000 - 02/26/2001 -- Created example code from
**									existing works.
**		03/15/2001 -- added support for MVI46 platform
**		03/21/2001 -- added comments
**		03/28/2001 -- added bios call to enable console from application
**		04/04/2002 -- updated mvibpapi files
**		11/10/2003 -- added support for Ethernet
**		12/25/2003 -- added support for PTQ platform
**      11/09/2006 -- ported to Digital Mars compiler
**
**	Title:	This file contains the main application example code
**			for the ADM module.
**
**  Abstract:
**
**
**	This program may serve as a starting point or an example
**	for custom applications.
**
**  Environment:	MVI
**                  MS-DOS
**                  Borland C/C++ Compiler (16-bit)
**					Digital Mars C/C++ Compiler v8.49 (16-bit DOS)
**
**
** ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
** and re-distribute this program provided that this copyright notice and
** license appear on all copies of the software.
**
** Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
** IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
** HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
** BY THE LICENSEE.
**
** PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
** DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
** DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
** ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
**
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**	COMPILER SWITCHES TO BUILD DIFFERENT VERSIONS OF THE SOFTWARE
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**	Include files
**---------------------------------------------------------------------------
*/

#include "..\..\ADM-SAMPLE\inc\main_app.h"		/* primary application header file */

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>
#include <conio.h>

#define SOCKET_ENABLE
#ifdef SOCKET_ENABLE
#include "admnetapi.h"
#include "wattcp.h"
#endif
/*---------------------------------------------------------------------------
**	CONSTANT DEFINITIONS
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**	Function prototypes
**---------------------------------------------------------------------------
*/

static void interrupt intctl_c(void);
static void interrupt intcrit(void);

int startup(void);
int shutdown(void);
void App_LED(void);
void ShowVersion(void);

int CtrlDataBlock(unsigned short blockNo);

extern void CommRun(int);
extern int DebugMenu(void);
extern void ProcessCfg(void);
extern int ReadCfg(void);


/*---------------------------------------------------------------------------
**	Variable definitions
**---------------------------------------------------------------------------
*/

/* structures */
ADM_INTERFACE     interface;
ADM_PRODUCT       prd;
ADM_BT_DATA       bt_data;
ADM_BLK_ERRORS    bt_err;
ADM_MODULE        module;
ADM_PORT          ports[MAX_APP_PORTS];
ADM_PORT_ERRORS   port_err[MAX_APP_PORTS];
ADMVERSIONINFO    adm_version;
#ifdef SOCKET_ENABLE
ADMNETVERSIONINFO    admnet_version;
#endif
/* pointers to structures */
ADM_INTERFACE * interface_ptr;

/* timer variables */
unsigned short tmlast;
long tmled;

/* status counters */
#ifndef MVI46
int stat_cnt = 0;
#endif

#ifndef MVI94
int stat_db = 0;
#endif

ADMHANDLE adm_handle;					   /* handle to ADM API */

#if defined(MVI56)
static MVICIPVERSIONINFO	verinfo;    /* backplane API version struct */
static MVICIPIDOBJ			idobj;      /* module info struct */
#else
static MVIBPVERSIONINFO		verinfo;    /* backplane API version struct */
static MVIBPMODULEINFO		idobj;		/* module info struct */
   #if defined(MVI71)
   static MVISCVERSIONINFO scverinfo;  /* side-connect API version struct */
   #endif
#endif
static MVISPVERSIONINFO		spverinfo;	/* serial API version struct */

#ifdef SOCKET_ENABLE

char sockName1[] = "SendSocket";
int buffSize1 = 4096;
int port_1 = 6565;
int numSocket1 = 1;

char sockName2[] = "ReceiveSocket";
int buffSize2 = 4096;
int port_2 = 6565;
int numSocket2 = 1;

#endif

/*---------------------------------------------------------------------------
**	Functions
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
**	Ctrl-C signal handling function.  When a Ctrl-C is recognized, this
**	function is called.  The function ignores the request and must reinstall
**	the signal handler for future calls.
**---------------------------------------------------------------------------
*/

static void interrupt intctl_c(void)
{
	return;
}


static void interrupt intcrit(void)
{
	_AX = 0;						/* ignore critical error */
}


/*---------------------------------------------------------------------------
**	Main entry point
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
**
**	Entry point:
**		main
**
**	Description:
**		This is the entry point of the ADM example application.
**		This routine initializes the module, then enters the main loop
**		where the module communicates with the PLC via the backplane, and
**		communicates through the application serial ports.
**
**	Arguments:
**		none
**
**	External effects:
**
**
**	Return value:
**		none
**
**---------------------------------------------------------------------------
**	Notes:
**
**		debugging/error printf's will only be seen if console is enabled.
**
**---------------------------------------------------------------------------
*/
void main(void)
{
	int done = FALSE;
	int i;
#ifdef SOCKET_ENABLE
	char fromIP[64];
	char holdingReg[100];
	int readLen = 0;
	int sendLen = 0, rec;
   int option;
   int result;
#endif

#ifdef __DMC__
	extern int _8087;

	_8087 = 0; /* never use 80x87 Math Coprocessor */
#endif

#ifndef MVI94
	/* enable console on COM1 */
	ADM_SetConsolePort(COM1);
	/* set console to 57600 baud */
	ADM_SetConsoleSpeed(COM1, 57600L);
#endif

	/* open ADM API and get handle */
	if(ADM_Open(&adm_handle) != ADM_SUCCESS)
	{
		printf("\nFailed to open ADM API... exiting program\n");
		exit(1);
	}

	/* send status message to the status/debug port */
	printf("\nProgram Initialization....\n");

	/******************************************************************
		This section is required for the ADM API to function.
		The names of the structures may be changed to suit the
		developer's needs.  The interface structure must be initialized
		before it can be used.
	*******************************************************************
	*/

	/* initialize structure pointers */
	interface_ptr = &interface;
	interface.adm_product_ptr = &prd;
	interface.adm_bt_data_ptr = &bt_data;
	interface.adm_bt_err_ptr = &bt_err;
	interface.adm_module_ptr = &module;
	for(i=0;i<MAX_APP_PORTS;i++)
	{
		interface.adm_port_ptr[i] = &ports[i];
	}
	for(i=0;i<MAX_APP_PORTS;i++)
	{
		interface.adm_port_errors_ptr[i] = &port_err[i];
	}

	/* initialize ADM_INTERFACE function pointer members */
	/******************************************************

		These six functions are required if the ADM API is
		used.  The names of the functions can be changed as
		well as the code in the functions.  The interface
		structure member names must be the same however.  The
		minimum required is an empty function.  For example:

		void startup(void)
		{
		}

	*******************************************************/

	interface.startup_ptr = startup;
	interface.shutdown_ptr = shutdown;
	interface.version_ptr = ShowVersion;
	interface.user_menu_ptr = DebugMenu;
	interface.process_cfg_ptr = ProcessCfg;
	interface.ctrl_data_block_ptr = CtrlDataBlock;

	/* clear structures */
	memset(interface.adm_product_ptr, 0, sizeof(ADM_PRODUCT));
	memset(interface.adm_bt_data_ptr, 0, sizeof(ADM_BT_DATA));
	memset(interface.adm_bt_err_ptr, 0, sizeof(ADM_BLK_ERRORS));
	memset(interface.adm_module_ptr, 0, sizeof(ADM_MODULE));
	for(i=0;i<MAX_APP_PORTS;i++)
	{
		memset(interface.adm_port_ptr[i], 0, sizeof(ADM_PORT));
	}
	for(i=0;i<MAX_APP_PORTS;i++)
	{
		memset(interface.adm_port_errors_ptr[i], 0, sizeof(ADM_PORT_ERRORS));
	}

	/* clear application error flag */
	interface.Apperr = 0;

	/************************ end of section ******************************/

#ifdef SOCKET_ENABLE
	/* initialize TCP/IP socket */
	sock_init();    //initialize the socket interface
//#if defined(MVI56)
	/* initialize each socket */
	if(ADM_init_socket(numSocket1, port_1, buffSize1, sockName1) != SK_SUCCESS)
	{
		printf("Error: Initialize Socket %s\n", sockName1);
		ADM_release_sockets();
	}
//#elif defined(PTQ)
	/* initialize each socket */
	if(ADM_init_socket(numSocket2, port_2, buffSize2, sockName2) != SK_SUCCESS)
	{
		printf("Error: Initialize Socket %s\n", sockName2);
		ADM_release_sockets();
	}
//#endif
#endif

	/* initialize database */
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_STATUS, ADM_LED_FAULT);
#if !defined(PTQ)
	printf("Allocate & Initalize Database....\n");
	if(ADM_DBOpen(adm_handle, ADM_MAX_DB_REGS) != ADM_SUCCESS)
	{
		printf("Error setting up Database!\n");
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_OFF);
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_STATUS, ADM_LED_FAULT);
		return;
	}
#endif

	ADM_DBZero(adm_handle);			/* initialize database to zero */

	/* fill product structure with version data */
	strcpy(prd.ProdName,"ADM ");	/* product name */
	strcpy(prd.Rev,"1.06");			/* product revision */
	strcpy(prd.Op,"1106");			/* month / year */
	strcpy(prd.Run,"0901");			/* day / run */

	disable();						   /* disable interrupts */
	setvect(0x24, intcrit);			/* install in ISR handler for CTRL-C */
	setvect(0x23, intctl_c);   	/* install in ISR handler for CTRL-C */
	setvect(0x1B, intctl_c);   	/* install in ISR handler for CTRL-Break */
	setcbrk(0);                	/* force DOS to ignore Ctrl-C */
	enable();                   	/* enable interrupts */

	printf("Open Communication Ports....\n");

	/* open application port 1 (COM2) */
	for(i=0;i<MAX_APP_PORTS;i++)
	{
		if(MVIsp_Open(COM2+i, BAUD_9600, PARITY_NONE, WORDLEN8, STOPBITS1) != MVI_SUCCESS)
		{
			printf("ERROR: Cannot open COM%d application port!\n", i+2);
			ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);
			ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_OFF);
			ADM_SetLed(adm_handle, interface_ptr, ADM_LED_STATUS, ADM_LED_FAULT);
			return;
		}
	}

#if defined(MVI71)
   /* Determine if backplane or side-connect interface is used */
   interface.cfg_file = ADM_ReadSCFile(adm_handle, 1);
#endif

	/* open the backplane driver */
	ADM_BtOpen(adm_handle, interface_ptr, 1);
	if(startup())
	{
		shutdown();
		printf("ERROR: Startup function failed!\n");
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_OFF);
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_STATUS, ADM_LED_FAULT);
		return;
	}

	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_ON);
	tmled = 100000L;

	interface.pass_cnt = 0;

	/* main loop for program */
	while(!done)
	{
		interface.pass_cnt++;
#if defined(MVI56) || defined(MVI71)
		stat_db++;
#endif


#ifndef MVI71
		/* call backplane transfer logic */
		ADM_BtFunc(adm_handle, interface_ptr, 1);
#else
		if(!interface.cfg_file)  //use block transfer
			ADM_BtFunc(adm_handle, interface_ptr, 1);                  //call backplane transfer logic
		else           //use side-connect interface
		{
			if((stat_db & 0x03) == 3)  //data update every ~10 milliseconds
				ADM_ScScan(adm_handle, interface_ptr, 1);
		}
#endif

#ifdef SOCKET_ENABLE
      if (kbhit)
      {
         option = getch();

         switch (option) {
            case '?':
               printf("What Test do you want to do today?\n");
               printf("     1- Open Connection Only\n");
               printf("     2- Close Connection Only\n");
               printf("     3- Test Connection Status\n");
               printf("     4- Read Data\n");
               printf("     5- Write Data\n");
               printf("     6- receive Data\n");
               printf("     7- send Data\n");
               printf("     0- Quit\n");
               printf("\n");

            break;
            case '0':
//               sock_exit();
               shutdown();
               exit(0);
            break;
            case '1':

               while ((result = ADM_open_sk(sockName1, "0.0.0.0", USE_TCP))==SK_PROCESS_SOCKET){}

               if (result==SK_SUCCESS)
               {
                  printf("succesfuly Opened a connection!\n");
               } else {
                  printf("Error Opening a connection!  %d\n", result);
               }

            break;
            case '2':

               ADM_close_sk(sockName1);
               printf ("Connection Closed!\n");

           break;
            case '3':
               if(ADM_is_sk_open(sockName1) != SK_SUCCESS) {
                  printf("Socket not Opened\n");
               } else {
                  printf("Socket Opened\n");
               }
            break;

            case '4':

               while ((result=ADM_receive_sk(sockName1, holdingReg, &readLen, fromIP)) == SK_PROCESS_SOCKET){}

               if(result == SK_SUCCESS)
               {
                  printf("Received data!\n");
               	printf("Length == %d\n", readLen);
         	      for (i=0; i<readLen; i++)
               	{
               		printf("%c", *(holdingReg+i));
               	}
         	      printf("\n");

     	         } else {
                  printf("Received no data Error: %d\n",result);
               }
            break;
            case '5':

               sprintf(holdingReg,"abcdefghijklmnopqrstuvwxyz-");
               sendLen = 27;

               while ((result = ADM_send_sk(sockName1, holdingReg, &sendLen)) == SK_PROCESS_SOCKET){}

               if(result == SK_SUCCESS)
               {
                  printf("Data: %s Sent \n", holdingReg);
               	//printf("%s\n", holdingReg);
                 	readLen = 0;
                 	sendLen = 0;
               } else {
                  printf("Error sending data\n");
               }

            break;
            case '6':
               while((rec = ADM_receive_socket(sockName1, holdingReg, &readLen, USE_TCP)) == SK_PROCESS_SOCKET){}
               if(rec == SK_SUCCESS)
	            {
	            	printf("Length == %d\n", readLen);
	            	for (i=0; i<readLen; i++)
	            	{
	            		printf("%c", *(holdingReg+i));
	            	}
   	         }
            break;
            case '7':
               sprintf(holdingReg,"abcdefghijklmnopqrstuvwxyz-");
               sendLen = 27;
               while((rec = ADM_send_socket(sockName1, holdingReg, &sendLen, "192.168.0.145", USE_TCP)) == SK_PROCESS_SOCKET){}
               if(rec == SK_SUCCESS)
               {
                  printf("%s\n", holdingReg);
               }
            break;
         }
      }
#endif

		/* handle protocol on each port */
		for(i=0; i < MAX_APP_PORTS; i++)
		{
			CommRun(i);						/* protocol driver */
		}

		if(ADM_ProcessDebug(adm_handle, interface_ptr) < 0)	/* debug port function */
			done = TRUE;

		/* move status data to database */
#ifndef MVI46
		if(module.err_freq)
		{
			stat_cnt++;
			if(stat_cnt >= module.err_freq)
			{
				ADM_SetStatus(adm_handle, interface_ptr, interface.pass_cnt);
				stat_cnt = 0;
			}
		}
#endif


#if defined(MVI56) || defined(MVI71)
		if(stat_db > 500)
		{
			ADM_SetBtStatus(adm_handle, interface_ptr, interface.pass_cnt);
			stat_db = 0;
		}
#endif

		/* update timers */

		if(ADM_CheckTimer(adm_handle, &tmlast, &tmled) == 1)	/* LED flash timer for errors */
		{
			tmlast = ADM_StartTimer(adm_handle);
			tmled = 100000L;
			App_LED();
		}
	}

	shutdown();
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_STATUS, ADM_LED_FAULT);
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_OFF);
	ADM_Close(adm_handle);					/* close ADM API */
}


/*---------------------------------------------------------------------------
**
**	Description:
**		This routine reads the module configuration from the processor
**		and re-initializes the application serial ports.
**
**	Arguments:
**		none
**
**	External effects:
**
**
**	Return value:
**		0 = success, 1 = fail
**
**---------------------------------------------------------------------------
*/

int startup(void)
{
	int i;
	long dummy = 0L;

	printf("\nReloading Program Values....\n");
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_ON);
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_ON);
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_STATUS, ADM_LED_FAULT);

#if defined(MVI94) || defined(PTQ) || defined(MVI69)
	printf("Close Internal database....\n");
	ADM_DBClose(adm_handle);

	printf("Read Configuration....\n");
	ReadCfg();

	printf("Open Internal database....\n");
	if(ADM_DBOpen(adm_handle, module.max_regs) != ADM_SUCCESS)
	{
		return 1;
	}
#endif
	printf("Zero database....\n");
	ADM_DBZero(adm_handle);			/* initialize database to zero */

#if !defined( MVI94 ) && !defined( PTQ )
	/* read the module configuration from processor */
   #if defined(MVI71)
      if(!interface.cfg_file)  // ignor the side connect
      {
         if(ADM_ReadBtCfg(adm_handle, interface_ptr, 1))  // initialize for backplane interface.
            return 1;
      }
      else  // use the side connect. the value in the config side-connect file is between 4-200
      {
         if(ADM_ReadScCfg(adm_handle, interface_ptr, 1))  //initialize for PLC side-connect interface
         {
      	   printf("ADM_ReadScCfg() failed.");
           	return 1;
         }

      }
   #else
   	if(ADM_ReadBtCfg(adm_handle, interface_ptr, 1))
	   	return 1;
   #endif
#endif

	tmlast = ADM_StartTimer(adm_handle);

	for(i=0; i < MAX_APP_PORTS; i++)
	{
		MVIsp_Close(COM2+i);

		if(MVIsp_Open(COM2+i, ports[i].baud, ports[i].parity, ports[i].databits,
			ports[i].stopbits) != MVI_SUCCESS)
		{
			printf("ERROR: Cannot open COM%d port for application protocol!\n",i+2);
			return 1;
		}

		if(ports[i].CTS == 'Y') 		/* check for CTS */
			MVIsp_SetHandshaking(COM2+i, HSHAKE_RTSCTS);
		else
			MVIsp_SetHandshaking(COM2+i, HSHAKE_NONE);

		MVIsp_SetRTS(COM2+i, OFF);
		MVIsp_SetDTR(COM2+i, ON);

		ADM_CheckTimer(adm_handle, &ports[i].tmlast, &dummy);
		ports[i].state    = -1;
		ports[i].ComState = 0;
	}

	ADM_CheckTimer(adm_handle, &tmlast, &dummy);

	ShowVersion();

	/* write buffer to console */
	while(interface.buff_len)
	{
		interface.buff_len = ADM_ConPrint(adm_handle, interface_ptr);
	}

	printf("Press ? for menu help.\n\n");

	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_STATUS, ADM_LED_OK);
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_OFF);

	return 0;
}


/*---------------------------------------------------------------------------
**
**	Description:
**		This routine closes the communication ports and the backplane driver.
**
**	Arguments:
**		none
**
**	External effects:
**
**
**	Return value:
**		0 = success
**
**---------------------------------------------------------------------------
*/

int shutdown(void)
{
	int i;

	printf("\nProgram Shutdown....\n");

#ifdef SOCKET_ENABLE
	printf("Releasing Sockets....");
	ADM_release_sockets();
#endif

	printf("Closing communication ports....\n");
	for(i=0; i < MAX_APP_PORTS; i++)
	{
		MVIsp_SetRTS(COM2+i, OFF);
		MVIsp_SetDTR(COM2+i, OFF);
		MVIsp_Close(COM2+i);
	}
	/* close the backplane driver */
	printf("Closing Backplane Driver....\n");
	ADM_BtClose(adm_handle, interface_ptr);

	/* close database */
	printf("De-allocating Module Database....\n");
	ADM_DBClose(adm_handle);

	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_OFF);
	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_STATUS, ADM_LED_OK);
	printf("Program Terminated.\n\n");
	return 0;
}


/*---------------------------------------------------------------------------
**
**	Description:
**		This routine traps communication errors and flashes the error LED on
**		and off.
**
**	Arguments:
**		none
**
**	External effects:
**
**
**	Return value:
**		none
**
**---------------------------------------------------------------------------
*/

void App_LED(void)
{
	if(!interface.Apperr)
	{
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);
		interface.Apperr = 0;
	}
	else
		ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_ON);
}


/*---------------------------------------------------------------------------
**
**	Description:
**		This routine displays version information.  The display
**		information is written to a buffer where the processing
**		can be controlled in order to reduce interference with
**		other processes.  If called outside of the debug menu
**		the buffer must be emptied before moving on.
**
**	Arguments:
**		none
**
**	External effects:
**		Uses debug port console buffer.
**
**	Return value:
**		none
**
**---------------------------------------------------------------------------
*/

void ShowVersion(void)
{
	ADM_GetVersionInfo(adm_handle, &adm_version);
#ifdef SOCKET_ENABLE
	ADM_NET_GetVersionInfo(&admnet_version);
#endif
#if defined(MVI56)
	MVIcip_GetVersionInfo(interface.handle, &verinfo);
	MVIcip_GetIdObject(interface.handle, &idobj);
#else
	MVIbp_GetVersionInfo(interface.handle, &verinfo);
	MVIbp_GetModuleInfo(interface.handle, &idobj);
   #if defined(MVI71)
   MVIsc_GetVersionInfo(interface.sc_handle, &scverinfo);
   #endif
#endif
	MVIsp_GetVersionInfo(&spverinfo);

#if defined(MVI71)
   if(interface.cfg_file)  // ignor the side connect
   {

	sprintf(interface.buff,"\nVERSION INFORMATION:\n\n\
  %s\n\
  (c) 1999-2006, ProSoft Technology, Inc.\n\n\
  PRODUCT NAME CODE         : %c%c%c%c\n\
  SOFTWARE REVISION LEVEL   : %c%c%c%c\n\
  OPERATING SYSTEM REVISION : %c%c%c%c\n\
  RUN NUMBER                : %c%c%c%c\n\n\
  BACKPLANE DRIVER VERSION  : %d.%d\n\
  BACKPLANE API VERSION     : %d.%d\n\
  SIDE-CONNECT API VERSION  : %d.%d\n\
  SERIAL API VERSION        : %d.%d\n\
  ADM API VERSION           : %d.%d\n\
  MODULE NAME : %s\n\
  VENDOR ID   : %-6u   DEVICE TYPE   : %-6d\n\
  PRODUCT CODE: %-6u   SERIAL NUMBER : %08lX\n\
  REVISION    : %d.%d\n\n",
	PRODUCT_NAME,
	prd.ProdName[0],prd.ProdName[1],prd.ProdName[2],prd.ProdName[3],
	prd.Rev[0],prd.Rev[1],prd.Rev[2],prd.Rev[3],
	prd.Op[0],prd.Op[1],prd.Op[2],prd.Op[3],
	prd.Run[0],prd.Run[1],prd.Run[2],prd.Run[3],
	verinfo.BPDDSeries, verinfo.BPDDRevision,
	verinfo.APISeries, verinfo.APIRevision,
	scverinfo.APISeries, scverinfo.APIRevision,
	spverinfo.APISeries, spverinfo.APIRevision,
	adm_version.APIRevisionMajor, adm_version.APIRevisionMinor,
	idobj.Name,
	idobj.VendorID, idobj.DeviceType,
	idobj.ProductCode, idobj.SerialNo,
	idobj.MajorRevision, idobj.MinorRevision);

	interface.buff_ch = 0;
	interface.buff_len = strlen(interface.buff);

   }
   else
   {
#endif

#ifdef SOCKET_ENABLE
	sprintf(interface.buff,"\nVERSION INFORMATION:\n\n\
  %s\n\
  (c) 1999-2006, ProSoft Technology, Inc.\n\n\
  PRODUCT NAME CODE         : %c%c%c%c\n\
  SOFTWARE REVISION LEVEL   : %c%c%c%c\n\
  OPERATING SYSTEM REVISION : %c%c%c%c\n\
  RUN NUMBER                : %c%c%c%c\n\n\
  BACKPLANE DRIVER VERSION  : %d.%d\n\
  BACKPLANE API VERSION     : %d.%d\n\
  SERIAL API VERSION        : %d.%d\n\
  ADM API VERSION           : %d.%d\n\
  ADMNET API VERSION        : %d.%d\n\
  MODULE NAME : %s\n\
  VENDOR ID   : %-6u   DEVICE TYPE   : %-6d\n\
  PRODUCT CODE: %-6u   SERIAL NUMBER : %08lX\n\
  REVISION    : %d.%d\n\n",
	PRODUCT_NAME,
	prd.ProdName[0],prd.ProdName[1],prd.ProdName[2],prd.ProdName[3],
	prd.Rev[0],prd.Rev[1],prd.Rev[2],prd.Rev[3],
	prd.Op[0],prd.Op[1],prd.Op[2],prd.Op[3],
	prd.Run[0],prd.Run[1],prd.Run[2],prd.Run[3],
	verinfo.BPDDSeries, verinfo.BPDDRevision,
	verinfo.APISeries, verinfo.APIRevision,
	spverinfo.APISeries, spverinfo.APIRevision,
	adm_version.APIRevisionMajor, adm_version.APIRevisionMinor,
	admnet_version.APIRevisionMajor, admnet_version.APIRevisionMinor,
	idobj.Name,
	idobj.VendorID, idobj.DeviceType,
	idobj.ProductCode, idobj.SerialNo,
	idobj.MajorRevision, idobj.MinorRevision);

	interface.buff_ch = 0;
	interface.buff_len = strlen(interface.buff);
#else
	sprintf(interface.buff,"\nVERSION INFORMATION:\n\n\
  %s\n\
  (c) 1999-2006, ProSoft Technology, Inc.\n\n\
  PRODUCT NAME CODE         : %c%c%c%c\n\
  SOFTWARE REVISION LEVEL   : %c%c%c%c\n\
  OPERATING SYSTEM REVISION : %c%c%c%c\n\
  RUN NUMBER                : %c%c%c%c\n\n\
  BACKPLANE DRIVER VERSION  : %d.%d\n\
  BACKPLANE API VERSION     : %d.%d\n\
  SERIAL API VERSION        : %d.%d\n\
  ADM API VERSION           : %d.%d\n\
  MODULE NAME : %s\n\
  VENDOR ID   : %-6u   DEVICE TYPE   : %-6d\n\
  PRODUCT CODE: %-6u   SERIAL NUMBER : %08lX\n\
  REVISION    : %d.%d\n\n",
	PRODUCT_NAME,
	prd.ProdName[0],prd.ProdName[1],prd.ProdName[2],prd.ProdName[3],
	prd.Rev[0],prd.Rev[1],prd.Rev[2],prd.Rev[3],
	prd.Op[0],prd.Op[1],prd.Op[2],prd.Op[3],
	prd.Run[0],prd.Run[1],prd.Run[2],prd.Run[3],
	verinfo.BPDDSeries, verinfo.BPDDRevision,
	verinfo.APISeries, verinfo.APIRevision,
	spverinfo.APISeries, spverinfo.APIRevision,
	adm_version.APIRevisionMajor, adm_version.APIRevisionMinor,
	idobj.Name,
	idobj.VendorID, idobj.DeviceType,
	idobj.ProductCode, idobj.SerialNo,
	idobj.MajorRevision, idobj.MinorRevision);

	interface.buff_ch = 0;
	interface.buff_len = strlen(interface.buff);
#endif

#if defined(MVI71)
   }
#endif
}


/*---------------------------------------------------------------------------
**
**	Description:
**		This routine is to generate block control,
**		which can be control from Concept's
**		Data Reference Editor.
**
**	Arguments:
**		blockNo:	This argument is Block Number.
**						This can be any number except
**						9998 (warm boot) or 9999 (cold boot).
**						Zero indicates no control and is nomally
**						used to reset control block from
**						the module.
**
**	External effects:
**		Uses Control Data Block from Concept's
**		Data Reference Editor.
**
**	Return value:
**		len = number of byte written back to PLC.
**				Always return at least two byte to indicate
**				successful operation.
**
**---------------------------------------------------------------------------
*/

int CtrlDataBlock(unsigned short blockNo)
{
	int len;		//length of byte written back to the PLC.
	switch(blockNo)
	{
		case 9000:
			ShowVersion();
			*interface.adm_bt_data_ptr->buff = 0;					//first byte always set to Zero
			*(interface.adm_bt_data_ptr->buff+1) = 9000;	//second byte indecates successful operation.
			len = 2;
			break;

		default:
			len = 0;
			break;
	}

	return len;
}
