;***	SDTE.INC -- Embedded DOS System Drive Table Entry.
;
;1.	Functional Description.
;	This structure defines the layout of an entry referenced by the
;	System Drive Table (SDT).  The SDT contains up to LASTDRIVE elements
;	of the following structure, and resides in the DOSDATA segment.
;	Each element describes the block device for a drive letter.  The
;	first element (#0) corresponds to drive A:, element #1 corresponds
;	to drive B:, and so on.  When a pathspec is cracked by the INT 21h
;	API functions, the drive obtained is used as an index into the SDT,
;	and the pointer in the SDT points to the SDTE which contains the
;	current directory for that drive, and other important stuff.
;
;	Each SDTE contains a "current working directory", or cwd, for the
;	drive it represents.  This is set by DosSetDir, and is used by
;	DosGetDir and IoCanonicalizePathName.	The cwd contains an ASCIIZ
;	string that does not contain "." or ".." entries; these are parsed
;	out by a call to IoCanonicalizePathName before DosSetDir will change
;	the cwd.  The cwd never starts with a leading backslash; the I/O
;	system supplies this by itself when talking to FATFSD.	The cwd
;	also does not contain a trailing backslash; this is supplied by
;	the I/O system when talking to FATFSD.	Here are some examples of
;	valid entries in the cwd:
;
;		db	0		; empty string (root directory).
;		db	'src', 0	; \src\ directory.
;		db	'src\x', 0	; \src\x directory.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

SDTE_DIRLEN	=	127		; len (directory string) < 128.

SDTE_SIGNATURE	=	1234h		; if ==, this is an SDTE.

SDTE		struc
sdte_sig	dw	?		; SDTE signature.
sdte_flags	dw	?		; flags, see below.
sdte_refcount	dw	?		; # reasons why SDTE can't be deleted.
sdte_handle	dw	?		; internal ID maintained by FSD.
sdte_dev	dd	?		; FWA, device driver header.
sdte_fsd	dw	?		; seg adr, FSD driver.
sdte_curdir	db	(SDTE_DIRLEN+1) dup (?) ; zero-byte terminated.
sdte_unit	db	?		; unit number within driver.
sdte_drive	db	?		; drive handle (SDT handle).
sdte_dpb	dw	?		; ofs FWA, fake DPB for funcs 1fh, 32h.
sdte_prefix	dw	?		; ofs FWA, ASCIIZ prefix in system pool.

;	The following fields are used by the governing FSD to maintain
;	information about this drive.  Naturally, this is file system
;	specific, so we don't declare these fields to be FAT-oriented.
;	However, as an example of use, the FAT FSD uses sdte_hint1 to
;	maintain the last sector where it successfully allocated a free
;	cluster for file extension/mkdir.  This hint allows these operations
;	to be optimized for performance.

sdte_hintflags	dw	?		; flags used by FSD.
sdte_hint1	dw	?		; long-term scratch for FSD.
sdte_hint2	dd	?		; long-term scratch for FSD.
SDTE		ends

;	WARNING: SDTE_FLAGS_FSDDEFINED must be equal to SHTE_FLAGS_FSDDEFINED.
;	WARNING: SDTE_FLAGS_DEVDEFINED must be equal to SHTE_FLAGS_DEVDEFINED.

SDTE_FLAGS_FSDDEFINED = 0001h		; FSD field is meaningful.
SDTE_FLAGS_DEVDEFINED = 0002h		; DEV field is meaningful.
SDTE_FLAGS_LOCKED     = 0004h		; SDTE is locked. read/write not permitted.
SDTE_FLAGS_PREFIX     = 0008h		; sdte_prefix is valid.
SDTE_FLAGS_NETWORK    = 0010h		; set if drive is remoted on a network.
