/**/
/*****************************************************************************
*
*   Title:        1771-MVI Side-Connect API Definitions
*
*   Abstract:     This file contains definitions and declarations
*                 needed for developing applications which use the 
*                 MVI Side-Connect API.
*
*
*   Environment:  1771-MVI Communications Module 
*                 Borland/Microsoft C/C++ Compiler 
*                 Embedded DOS 6-XL
*
*                 Copyright (c) 2000-2001 Online Development, Inc.
*
*****************************************************************************/

#ifndef _MVISCAPI_H
#define _MVISCAPI_H

/***********************************
**      TYPE DEFINITIONS   
************************************/
typedef unsigned char   BYTE;       // 8-bit unsigned value
typedef unsigned short  WORD;       // 16-bit unsigned value
typedef unsigned long   DWORD;      // 32-bit unsigned value
typedef unsigned short  HANDLE;     // API handle


/************************************
**    API FUNCTION RETURN CODES
*************************************/
#define MVISC_SUCCESS             0       // function returned successfully
#define MVISC_ERR_PLCTIMEOUT      1       // No response from PLC
#define MVISC_ERR_DPRAMFAIL       2       // Dual-Port RAM test failed
#define MVISC_ERR_BADCONFIG       3       // BIOS CMOS configuration data is corrupt (prob not an MVISC)
#define MVISC_ERR_ONLINEFAIL      4       // Could not go online
#define MVISC_ERR_REOPEN          5       // Already open
#define MVISC_ERR_NOACCESS        6       // Invalid handle
#define MVISC_ERR_NOTRUNMODE      7       // PLC Not in Run Mode
#define MVISC_ERR_BADPARAM        8       // Parameter is invalid
#define MVISC_ERR_XFERFAIL        9       // Raw transfer failed
#define MVISC_ERR_PCCCFAIL        10      // PCCC transfer failed
#define MVISC_ERR_NOTCONFIG       11      // Side Connect is not configured (check BIOS setup)
#define MVISC_ERR_PENDING         12      // Operation has not yet completed
#define MVISC_ERR_OPFAILED        13      // Operation failed (system call returned error)
#define MVISC_ERR_OPTIMEOUT       14      // Timed out waiting for operation to complete


/*****************************************************************************
** PCCC STATUS CODES
**
** If MVISC_ERR_PCCCFAIL is returned from an API function,
** MVIsc_GetLastPcccError may be called to retrieve the PCCC
** Status and Extended Status Codes.  If the Status Code is 0xF0,
** then the Extended Status Code contains the error code.
******************************************************************************/
#define MVISC_PCCC_STS_SUCCESS        0x00    // Success; no error
#define MVISC_PCCC_STS_INVALID        0x10    // Illegal command or format
#define MVISC_PCCC_STS_BADADDR        0x50    // Addressing problem
#define MVISC_PCCC_STS_PROG           0x70    // PLC is in program mode
#define MVISC_PCCC_STS_EXT            0xF0    // The error code is in the extended status byte.
 
/*****************************************
** PCCC EXTENDED STATUS CODES
******************************************/
#define MVISC_PCCC_EXTSTS_SUCCESS     0x00    // Success; no error
#define MVISC_PCCC_EXTSTS_BADPARAM    0x01    // Illegal paramter
#define MVISC_PCCC_EXTSTS_NOTFOUND    0x06    // Address does not point to usable object
#define MVISC_PCCC_EXTSTS_BADSIZE     0x07    // File is wrong size
#define MVISC_PCCC_EXTSTS_TOOBIG      0x09    // File is too large
#define MVISC_PCCC_EXTSTS_ACCESS      0x0B    // Access denied, improper privilege
#define MVISC_PCCC_EXTSTS_BADCMD      0x0E    // Command cannot be executed
#define MVISC_PCCC_EXTSTS_NOACCESS    0x10    // No access
#define MVISC_PCCC_EXTSTS_ILLEGAL     0x11    // Illegal data type
#define MVISC_PCCC_EXTSTS_COMFAIL     0x17    // Cannot communicate with module


/*****************************************************************************
** PLC STATUS WORD BITS
**
** The bits in the status word returned by MVIsc_GetPLCStatus are defined
** below:
******************************************************************************/
#define MVISC_PLCSTS_RAM_BAD          0x0001      // RAM is bad
#define MVISC_PLCSTS_RUN_MODE         0x0002      // Processor is in Run Mode
#define MVISC_PLCSTS_TEST_MODE        0x0004      // Processor is in Test Mode
#define MVISC_PLCSTS_PROG_MODE        0x0008      // Processor is in Program Mode
#define MVISC_PLCSTS_BURN_EEPROM      0x0010      // Burning EEPROM
#define MVISC_PLCSTS_DWNLD_MODE       0x0020      // Download Mode
#define MVISC_PLCSTS_EDITS_ENAB       0x0040      // Edits are enabled
#define MVISC_PLCSTS_REM_MODE         0x0080      // Remote modes
#define MVISC_PLCSTS_FRC_ENAB         0x0100      // Forces are enabled
#define MVISC_PLCSTS_FRC_PRES         0x0200      // Forces are present
#define MVISC_PLCSTS_EEPROM_SUCC      0x0400      // EEPROM programming successful
#define MVISC_PLCSTS_ONLINE_EDIT      0x0800      // On-line editing
#define MVISC_PLCSTS_DEBUG_MODE       0x1000      // Debug mode
#define MVISC_PLCSTS_PROG_CKSM        0x2000      // User program checksum done
#define MVISC_PLCSTS_LAST_SCAN        0x4000      // Last scan of ladder or SFC step
#define MVISC_PLCSTS_FIRST_SCAN       0x8000      // First scan of ladder or SFC step


/*****************************************************************************
** PLC MAJOR FAULT BITS
**
** The bits in the major fault word returned by MVIsc_GetPLCStatus are defined
** below:
******************************************************************************/
#define MVISC_PLCFLT_PROG_MEM_BAD     0x0001      // Bad user program memory
#define MVISC_PLCFLT_BAD_OPRN_ADDR    0x0002      // Illegal operand address
#define MVISC_PLCFLT_PROG_ERROR       0x0004      // Programming error
#define MVISC_PLCFLT_SFC_ERROR        0x0008      // Function chart error
#define MVISC_PLCFLT_DUP_LABELS       0x0010      // Duplicate labels found
#define MVISC_PLCFLT_PWR_FAIL         0x0020      // Power loss fault
#define MVISC_PLCFLT_PERIPHERAL       0x0040      // Peripheral fault (Chan 3)
#define MVISC_PLCFLT_USER_JSR         0x0080      // User jsr to fault routine
#define MVISC_PLCFLT_WATCHSOG         0x0100      // Watchdog fault
#define MVISC_PLCFLT_BAD_CONFIG       0x0200      // System illegally configured
#define MVISC_PLCFLT_HWFAIL           0x0400      // Hardware fault
#define MVISC_PLCFLT_NOMCP            0x0800      // MCP file does not exist or is not ladder/SFC
#define MVISC_PLCFLT_NOPII            0x1000      // PII program does not exist or is not ladder
#define MVISC_PLCFLT_NOSTI            0x2000      // STI program does not exist or is not ladder
#define MVISC_PLCFLT_NOFLT            0x4000      // Fault program does not exist or is not ladder
#define MVISC_PLCFLT_NOFAULTED        0x8000      // Faulted program does not exist or is not ladder


/************************************************************************
** PLC Message Instruction Type Definitions
**
** These values are passed to the MVIsc_PLCMsgWait function
*************************************************************************/
#define MVISC_MSGTYP_READ         0           // PLC Message-read handler
#define MVISC_MSGTYP_WRITE        1           // PLC Message-write handler


/************************************************************************
** Clear Fault Flag Bit Definitions
**
** These values are passed to the MVIsc_ClearFault function
*************************************************************************/
#define MVISC_CLRFLT_MAJOR        1           // Clear PLC major fault
#define MVISC_CLRFLT_MINOR        2           // Clear PLC minor fault


/************************************************************************
** PLC Mode Definitions
**
** These values are passed to the MVIsc_SetPLCMode function
*************************************************************************/
#define MVISC_PLCMODE_PROG        0           // Program mode
#define MVISC_PLCMODE_TEST        1           // Test mode
#define MVISC_PLCMODE_RUN         2           // Run mode


/************************************************************************
** PLC Data File Type Definitions
**
** These values are returned by the MVIsc_GetPLCFileInfo function in
** the filetype structure member.
*************************************************************************/
#define MVISC_PLCTYPE_O           0           // Output
#define MVISC_PLCTYPE_I           1           // Input
#define MVISC_PLCTYPE_S           2           // Status
#define MVISC_PLCTYPE_B           3           // Bit (binary)
#define MVISC_PLCTYPE_T           4           // Timer
#define MVISC_PLCTYPE_C           5           // Counter
#define MVISC_PLCTYPE_R           6           // Control
#define MVISC_PLCTYPE_N           7           // Integer
#define MVISC_PLCTYPE_F           8           // Floating-point
#define MVISC_PLCTYPE_PD          9           // PID
#define MVISC_PLCTYPE_BT          10          // Block Transfer
#define MVISC_PLCTYPE_MG          11          // Message
#define MVISC_PLCTYPE_SC          12          // SFC Status
#define MVISC_PLCTYPE_ST          13          // ASCII String
#define MVISC_PLCTYPE_A           14          // ASCII Display
#define MVISC_PLCTYPE_D           15          // BCD Display
#define MVISC_PLCTYPE_NOEXIST     9998        // File does not exist
#define MVISC_PLCTYPE_UNKNOWN     9999        // Unknown data type


/*****************************************************************************
** PLC Data Types
**
** These values are passed to the MVIsc_ReadPLC and MVIsc_WritePLC functions.
******************************************************************************/
#define MVISC_DTYP_WORD           0           // 16 bit word (integer, binary, BCD, ASCII) 
#define MVISC_DTYP_FLOAT          1           // 32 bit floating point


/*****************************************************************************
** PLC Access Definitions
**
** These values are passed to the MVIsc_ReadPLC and MVIsc_WritePLC functions.
******************************************************************************/
#define MVISC_ASYNC_ACCESS        0           // Perform the transfer immediately
#define MVISC_SYNC_ACCESS         1           // Perform the transfer at the end of scan


/************************************************************************
** PLC Data Table File Values
**
** These are the fixed PLC-5 file numbers.
*************************************************************************/
#define MVISC_FILENO_O            0           // Output file
#define MVISC_FILENO_I            1           // Input file
#define MVISC_FILENO_S            2           // Status file


/************************************************************************
** PLC Status File Element Values
**
** Some of the more common status file words
*************************************************************************/
#define MVISC_ELEMNO_S_LASTSCAN   8           // Last program scan (ms)
#define MVISC_ELEMNO_S_MAXSCAN    9           // Maximum program scan (ms)
#define MVISC_ELEMNO_S_MINFLT1    10          // Minor fault (word 1)
#define MVISC_ELEMNO_S_MAJFLT     11          // Major fault
#define MVISC_ELEMNO_S_MAJERR     12          // Major error code
#define MVISC_ELEMNO_S_MINFLT2    17          // Minor fault (word 2)
#define MVISC_ELEMNO_S_YEAR       18          // PLC clock year


/************************************************************************
** PLC Timer Structure Subelement Values
**
** These values may be passed to the MVIsc_ReadPLC and MVIscWritePLC
** functions to address individual structure members.
*************************************************************************/
#define MVISC_SUBEL_T_CTL         0           // Control/Status word
#define MVISC_SUBEL_T_PRE         1           // Preset value (signed word)
#define MVISC_SUBEL_T_ACC         2           // Accumulated value (signed word)


/************************************************************************
** PLC Counter Structure Subelement Values
**
** These values may be passed to the MVIsc_ReadPLC and MVIscWritePLC
** functions to address individual structure members.
*************************************************************************/
#define MVISC_SUBEL_C_CTL         0           // Control/Status word
#define MVISC_SUBEL_C_PRE         1           // Preset value (signed word)
#define MVISC_SUBEL_C_ACC         2           // Accumulated value (signed word)


/************************************************************************
** PLC Control Structure Subelement Values
**
** These values may be passed to the MVIsc_ReadPLC and MVIscWritePLC
** functions to address individual structure members.
*************************************************************************/
#define MVISC_SUBEL_R_CTL         0           // Control/Status word
#define MVISC_SUBEL_R_LEN         1           // Length (signed word)
#define MVISC_SUBEL_R_POS         2           // Position (signed word)


/************************************************************************
** PLC SFC Status Structure Subelement Values
**
** These values may be passed to the MVIsc_ReadPLC and MVIscWritePLC
** functions to address individual structure members.
*************************************************************************/
#define MVISC_SUBEL_SC_CTL        0           // Control/Status word
#define MVISC_SUBEL_SC_PRE        1           // Preset value (signed word)
#define MVISC_SUBEL_SC_TIM        2           // Active time (signed word)


/************************************************************************
** PLC Block-transfer Control Structure Subelement Values
**
** These values may be passed to the MVIsc_ReadPLC and MVIscWritePLC
** functions to address individual structure members.
*************************************************************************/
#define MVISC_SUBEL_BT_CTL        0           // Control/Status word
#define MVISC_SUBEL_BT_RLEN       1           // Requested word count (signed word)
#define MVISC_SUBEL_BT_DLEN       2           // Transmitted word count (signed word)
#define MVISC_SUBEL_BT_FILE       3           // File type (signed word)
#define MVISC_SUBEL_BT_ELEM       4           // Word number (signed word)
#define MVISC_SUBEL_BT_RGS        5           // Rack/Group/Slot (signed word)


/************************************************************************
** PLC Message Control Structure Subelement Values
**
** These values may be passed to the MVIsc_ReadPLC and MVIscWritePLC
** functions to address individual structure members.
*************************************************************************/
#define MVISC_SUBEL_MG_CTL        0           // Control/Status word
#define MVISC_SUBEL_MG_ERR        1           // Error code (signed word)
#define MVISC_SUBEL_MG_RLEN       2           // Requested length (signed word)
#define MVISC_SUBEL_MG_DLEN       3           // Done length (signed word)


/************************************************************************
** PLC PID Control Structure in PD File - Subelement Values
**
** These values may be passed to the MVIsc_ReadPLC and MVIscWritePLC
** functions to address individual structure members.
*************************************************************************/
#define MVISC_SUBEL_PD_CTL1       0           // Control/Status word 1
#define MVISC_SUBEL_PD_CTL2       1           // Control/Status word 2
#define MVISC_SUBEL_PD_SP         2           // Set point (float)
#define MVISC_SUBEL_PD_KP         4           // Proportional gain (float)
#define MVISC_SUBEL_PD_KI         6           // Initial gain (float)
#define MVISC_SUBEL_PD_KD         8           // Derivative gain (float)
#define MVISC_SUBEL_PD_BIAS       10          // Output bias % (float)
#define MVISC_SUBEL_PD_MAXS       12          // Maximum scaled value (float)
#define MVISC_SUBEL_PD_MINS       14          // Minimum scaled value (float)
#define MVISC_SUBEL_PD_DB         16          // Dead band (float)
#define MVISC_SUBEL_PD_SO         18          // Set output % (float)
#define MVISC_SUBEL_PD_MAXO       20          // Maximum output limit (float)
#define MVISC_SUBEL_PD_MINO       22          // Minimum output limit (float)
#define MVISC_SUBEL_PD_UPD        24          // Update time (float)
#define MVISC_SUBEL_PD_PV         26          // Process variable (float)
#define MVISC_SUBEL_PD_ERR        28          // Error: scaled (float)
#define MVISC_SUBEL_PD_OUT        30          // Output (float)
#define MVISC_SUBEL_PD_PVH        32          // PV alarm high (float)
#define MVISC_SUBEL_PD_PVL        34          // PV alarm low (float)
#define MVISC_SUBEL_PD_DVP        36          // Deviation alarm + (float)
#define MVISC_SUBEL_PD_DVN        38          // Deviation alarm - (float)
#define MVISC_SUBEL_PD_PVDB       40          // PV alarm dead band (float)
#define MVISC_SUBEL_PD_DVDB       42          // Deviation alarm dead band (float)
#define MVISC_SUBEL_PD_MAXI       44          // Maximum input (float)
#define MVISC_SUBEL_PD_MINI       46          // Minimum input (float)
#define MVISC_SUBEL_PD_TIE        48          // Tieback % (float)


/************************************************************************
** PLC PID Control Block in Integer File - Element Offsets
**
** These values may be used to offset into a PID control block in an
** integer file when using the MVIsc_ReadPLC and MVIscWritePLC
** functions.
**
** Note: These are not subelement values, as the subelement must be
** set to zero when accessing an Integer file.  These are element
** offset values, which may be added to the starting element of the
** PID Control Block to address an individual member.
*************************************************************************/
#define MVISC_ELOFF_PIDI_CTL        0         // Control/Status word
#define MVISC_ELOFF_PIDI_RES        1         // reserved word
#define MVISC_ELOFF_PIDI_SP         2         // Setpoint
#define MVISC_ELOFF_PIDI_KP         3         // Proportional gain (Independent)
#define MVISC_ELOFF_PIDI_KC         3         // Controller gain (ISA)
#define MVISC_ELOFF_PIDI_KI         4         // Integral gain (Independent)
#define MVISC_ELOFF_PIDI_TI         4         // Reset term (ISA)
#define MVISC_ELOFF_PIDI_KD         5         // Derivative gain (Independent)
#define MVISC_ELOFF_PIDI_TD         5         // Rate term X 100 (ISA)
#define MVISC_ELOFF_PIDI_FF         6         // Feedforward/Bias
#define MVISC_ELOFF_PIDI_SMAX       7         // Maximum scaling
#define MVISC_ELOFF_PIDI_SMIN       8         // Minimum scaling
#define MVISC_ELOFF_PIDI_DB         9         // Dead band
#define MVISC_ELOFF_PIDI_SETOUT     10        // Set output
#define MVISC_ELOFF_PIDI_LMAX       11        // Maximum output limit
#define MVISC_ELOFF_PIDI_LMIN       12        // Minimum output limit
#define MVISC_ELOFF_PIDI_DT         13        // Loop update time
#define MVISC_ELOFF_PIDI_PV         14        // Scaled PV value
#define MVISC_ELOFF_PIDI_ERR        15        // Scaled error value
#define MVISC_ELOFF_PIDI_CV         16        // Output


/* ************************************ */
/* **    STRUCTURES                  ** */
/* ************************************ */

/* ensure structures are word-aligned */
#ifdef __BORLANDC__
#pragma option -a
#endif /* _BORLANDC */

#ifdef _MSC_VER
#pragma pack(2)
#endif /* _MSC_VER */

/************************************************************
* Structure Name: MVISCVERSIONINFO
*
* Description:
*
*   Returned by MVIsc_GetVersionInfo().
*   API version numbers.
*
*************************************************************/
typedef struct tagMVISCVERSIONINFO 
{
    WORD        APISeries;                  // API series
    WORD        APIRevision;                // API revision
} MVISCVERSIONINFO;


/************************************************************
* Structure Name: MVISCCLOCK
*
* Description:
*
*   Returned by MVIsc_GetPLCClock().
*   Date and time from PLC-5.
*
*************************************************************/
typedef struct tagMVISCCLOCK
{
    WORD        year;                       // PLC-5 year
    WORD        month;                      // PLC-5 month
    WORD        day;                        // PLC-5 day
    WORD        hour;                       // PLC-5 hour
    WORD        minute;                     // PLC-5 minute
    WORD        second;                     // PLC-5 second
} MVISCCLOCK;


/************************************************************
* Structure Name: MVISCFILEINFO
*
* Description:
*
*   Returned by MVIsc_GetPLCFileInfo().
*   File size and data type from PLC-5.
*
*************************************************************/
typedef struct tagMVISCFILEINFO
{
    WORD        filetype;           // File data type (see MVI_PLCTYP_ definitions)
    WORD        num_elements;       // File size expressed in number of elements
    DWORD       num_words;          // File size expressed in number of words
} MVISCFILEINFO;

/* return packing alignment to default */
#ifdef __BORLANDC__
#pragma option -a-
#endif /* _BORLANDC */

#ifdef _MSC_VER
#pragma pack()
#endif /* _MSC_VER */


/*************************************
**      FUNCTION PROTOTYPES         **
*************************************/

/* Define a convenient macro for library function declarations */
#ifdef __cplusplus
#define MVIAPIENTRY extern "C" int pascal
#define MVIAPIENTRYW extern "C" WORD pascal
#else
#define MVIAPIENTRY int pascal
#define MVIAPIENTRYW WORD pascal
#endif


MVIAPIENTRY MVIsc_Open(HANDLE *);
MVIAPIENTRY MVIsc_Close(HANDLE);
MVIAPIENTRY MVIsc_GetPLCStatus(HANDLE, WORD *, WORD *);
MVIAPIENTRY MVIsc_WaitForEos(HANDLE, WORD);
MVIAPIENTRY MVIsc_ReadPLC(HANDLE, void *, WORD, WORD, WORD, WORD, WORD, int);
MVIAPIENTRY MVIsc_WritePLC(HANDLE, void *, WORD, WORD, WORD, WORD, WORD, int);
MVIAPIENTRY MVIsc_ErrorStr(int, char *);
MVIAPIENTRY MVIsc_GetVersionInfo(HANDLE, MVISCVERSIONINFO *);
MVIAPIENTRY MVIsc_RMWPLC(HANDLE, WORD, WORD, WORD, WORD, WORD);
MVIAPIENTRY MVIsc_GetPLCClock(HANDLE, MVISCCLOCK *);
MVIAPIENTRY MVIsc_PLCBTRead(HANDLE, WORD *, BYTE, BYTE, BYTE, BYTE);
MVIAPIENTRY MVIsc_PLCBTWrite(HANDLE, WORD *, BYTE, BYTE, BYTE, BYTE);
MVIAPIENTRY MVIsc_SyncPLCClock(HANDLE);
MVIAPIENTRY MVIsc_PLCMsgRead(HANDLE, void *, WORD, WORD, BYTE, WORD);
MVIAPIENTRY MVIsc_PLCMsgWrite(HANDLE, void *, WORD, WORD, BYTE, WORD);
MVIAPIENTRY MVIsc_PLCMsgWait(HANDLE, BYTE, BYTE, WORD);
MVIAPIENTRY MVIsc_GetLastPcccError(HANDLE, BYTE *, BYTE *);
MVIAPIENTRY MVIsc_ClearFault(HANDLE, BYTE);
MVIAPIENTRY MVIsc_SetPLCMode(HANDLE, BYTE);
MVIAPIENTRY MVIsc_GetPLCFileInfo(HANDLE, WORD, MVISCFILEINFO *);
MVIAPIENTRYW MVIsc_BCD2BIN(WORD);
MVIAPIENTRYW MVIsc_BIN2BCD(WORD);

#endif  /* _MVISCAPI_H */
