;***	KERNEL.INC -- Embedded DOS Kernel API Definitions for Assembly Language.
;
;1.	Functional Description.
;	This include file defines the symbols and structures that are used
;	to interact with the Embedded DOS kernel interface.
;
;2.	Modification History.
;	S. E. Jones	92/09/04.	#1.100, consolidated defines here.
;	S. E. Jones	92/12/18.	#1.101, added system event log.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

;	System-Dependent Interrupt Vectors.

SYSEVENTINT	=	02bh		; internal event logging interrupt.
DBGINT		=	02ch		; debugger formatting interrupt.
SYSINT		=	02dh		; system kernel function interrupt.
SYSINTALT   =  032h     ; MVIMOD jmc 11/18/99 alternate kernel entry point (does not enable ints)

;	System kernel function assignments.

SYS_ALLOCATE_THREAD	=	1
SYS_DEALLOCATE_THREAD	=	2
SYS_ENTER_CRITICAL_SECTION =	3
SYS_LEAVE_CRITICAL_SECTION =	4
SYS_PASS_TIME_SLICE	=	5
SYS_ALLOCATE_MUTEX	=	6
SYS_DEALLOCATE_MUTEX	=	7
SYS_ACQUIRE_MUTEX	=	8
SYS_RELEASE_MUTEX	=	9
SYS_ALLOCATE_EVENT	=	10
SYS_DEALLOCATE_EVENT	=	11
SYS_SET_EVENT		=	12
SYS_CLEAR_EVENT         =	13
SYS_PULSE_EVENT         =	14
SYS_ALLOCATE_TIMER	=	15
SYS_DEALLOCATE_TIMER	=	16
SYS_START_TIMER         =	17
SYS_STOP_TIMER		=	18
SYS_ALLOCATE_POOL	=	19
SYS_DEALLOCATE_POOL	=	20
SYS_KEEP_POOL		=	21
SYS_USEDOSDATA_DS	=	22
SYS_USEDOSDATA_ES	=	23
SYS_USEPSP_DS		=	24
SYS_USEPSP_ES		=	25
SYS_USEDGROUP_DS	=	26
SYS_USEDGROUP_ES	=	27
SYS_QUERY_EVENT         =	28
SYS_WAIT_EVENT		=	29
SYS_ALLOCATE_THREAD_LONG=	30
SYS_PRIORITIZE_THREAD	=	31
SYS_ABORT_THREAD	=	32
SYS_GET_FSHELP_ADDRESS	=	33
SYS_GET_IOHELP_ADDRESS	=	34
SYS_QUERY_THREAD_HANDLE =	35
SYS_ALLOCATE_OBJECT	=	36
SYS_ACCESS_OBJECT	=	37
SYS_RELEASE_OBJECT	=	38
SYS_DEALLOCATE_OBJECT	=	39
SYS_LOCK_OBJECT         =	40
SYS_UNLOCK_OBJECT	=	41
SYS_POINT_TO_OBJECT	=	42
SYS_QUERY_THREAD_INFO	=	43
SYS_SET_THREAD_INFO	=	44
SYS_MAX_KERNEL_FUNCTION =	(SYS_SET_THREAD_INFO)

;	Priorities for SetThreadPriority API.

THREAD_PRIORITY_LOW	=	0	; lowest priority.
THREAD_PRIORITY_DEFAULT =	16384	; default priority.
THREAD_PRIORITY_HI	=	32767	; highest priority.
THREAD_PRIORITY_RESERVED=	32768	; reserved levels 32768-65535.

;	Information types for Set/Query Thread Information API.

THREAD_INFOTYPE_URUN	=	1	; thread run appendage information type.
THREAD_INFOTYPE_USTOP	=	2	; thread block/stop appendage.
THREAD_INFOTYPE_UEXIT	=	3	; thread exit (NOT ABORT) appendage.
