;***	DOSERR.INC -- Embedded DOS Error Code Definitions for Assembly Language.
;
;1.	Functional Description.
;	This include file defines the symbolic Embedded DOS return codes.
;
;2.	Modification History.
;	S. E. Jones	92/09/04.	#1.100, consolidated defines here.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

DOSERR_SUCCESS		=	0	; command completed successfully.
DOSERR_INVALID_FUNCTION =	1	; invalid function number.
DOSERR_FILE_NOT_FOUND	=	2	; file not found.
DOSERR_PATH_NOT_FOUND	=	3	; path not found.
DOSERR_HANDLE_LIMIT	=	4	; too many open files (limit reached).
DOSERR_ACCESS_DENIED	=	5	; access is blocked.
DOSERR_INVALID_HANDLE	=	6	; invalid handle.
DOSERR_MEMORY_CORRUPTED =	7	; system memory block(s) corrupted.
DOSERR_NO_MEMORY	=	8	; insufficient memory (all in use).
DOSERR_INVALID_ADDRESS	=	9	; invalid memory block address.
DOSERR_INVALID_ENVIRON	=	10	; invalid environment.
DOSERR_INVALID_FORMAT	=	11	; invalid format.
DOSERR_INVALID_ACCESS	=	12	; invalid access code.
DOSERR_INVALID_DATA	=	13	; invalid data.
DOSERR_RESERVED_1	=	14	; this is reserved.
DOSERR_INVALID_DISK_DRIVE =	15	; invalid disk drive.
DOSERR_REMOVE_CUR_DIR	=	16	; attempt to remove current directory.
DOSERR_NOT_SAME_DEVICE	=	17	; not same device.
DOSERR_NO_MORE_FILES	=	18	; no more files in search.
DOSERR_WRITE_PROTECTED	=	19	; device/file is write protected.
DOSERR_UNKNOWN_UNIT	=	20	; unknown disk unit.
DOSERR_DRIVE_NOT_READY	=	21	; disk drive is not ready.
DOSERR_UNKNOWN_COMMAND	=	22	; unknown command.
DOSERR_DATA_ERROR	=	23	; CRC error.
DOSERR_BAD_REQUEST_LENGTH =	24	; bad request structure length.
DOSERR_SEEK_ERROR	=	25	; seek error.
DOSERR_UNKNOWN_MEDIA	=	26	; media type unknown.
DOSERR_SECTOR_NOT_FOUND =	27	; sector not found or missing.
DOSERR_OUT_OF_PAPER	=	28	; printer is out of paper.
DOSERR_WRITE_FAULT	=	29	; write fault.
DOSERR_READ_FAULT	=	30	; read fault.
DOSERR_GENERAL_FAILURE	=	31	; general failure.

;	Version 3.x and above error codes.

DOSERR_SHARING_VIOLATION =	32	; sharing violation.
DOSERR_LOCK_VIOLATION	=	33	; lock violation.
DOSERR_INVALID_DISK_CHANGE =	34	; disk was changed at a bad time.
DOSERR_FCB_UNAVAILABLE	=	35	; FCB was unavailable.
DOSERR_SHARING_BUFFER_OVFL =	36	; sharing buffer overflow.
DOSERR_INVALID_NETWORK_REQUEST = 50	; network request not supported.
DOSERR_NO_LISTENS	=	51	; remote computer not listening.
DOSERR_DUPLICATE_NAME	=	52	; duplicate name on network.
DOSERR_NAME_NOT_FOUND	=	53	; network name not found.
DOSERR_NETWORK_BUSY	=	54	; the network is busy.
DOSERR_NETWORK_DEVICE_GONE =	55	; the network device no longer exists.
DOSERR_ADAPTER_FAILURE	=	57	; network adapter hardware error.
DOSERR_NETWORK_RESPONSE_BAD =	58	; incorrect response from network.
DOSERR_NETWORK_ERROR	=	59	; unexpected network error.
DOSERR_INCOMPATIBLE_NETWORK =	60	; incompatible remote adapter.
DOSERR_PRINT_QUEUE_FULL =	61	; the print queue full.
DOSERR_PRINT_QUEUE_NOT_FULL =	62	; the print queue is not full.
DOSERR_PRINT_FILE_DELETED =	63	; the print job ran out of space.
DOSERR_NETWORK_NAME_DELETED =	64	; the local name was deleted.
DOSERR_ACCESS_DENIED_2	=	65	; access to named object denied.
DOSERR_FILE_ALREADY_EXISTS =	80	; the specified file already exists.
DOSERR_CANNOT_MAKE_DIRECTORY_ENTRY = 82 ; cannot make directory entry.
DOSERR_REDIRECTION_TABLE_FULL = 84	; too many redirections.
DOSERR_INVALID_PASSWORD =	86	; invalid password.
DOSERR_INVALID_PARAMETER =	87	; invalid parameter.
