/*
// PROGRAM NAME:  MT1C.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program is a simple example of how to write applications
//	in C that allocate threads to perform work in parallel.  This
//	example illustrates how to:
//
//	1. Allocate & deallocate threads to perform parallel work, and
//	2. Use event objects for synchronization of work, and
//	3. Guard access to critical code such as C library functions
//
//	This program is linked with GENERAL\LIB\OBJ\KERNEL.OBJ to gain
//	access to the kernel API.
//
// MODIFICATION HISTORY.
//	S. E. Jones	93/09/18.	#1.106, original.
//	S. E. Jones	95/08/17.	#3.0, added _loadds on thread functions.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE ARGUMENTS.
//	none.
//
// NOTICE:  Copyright (C) 1993-1995 General Software, Inc.
*/

#define VOID void
#define UCHAR unsigned char
#define USHORT unsigned short
#define ULONG unsigned long
#define FALSE 0
#define TRUE (!FALSE)

#include <stdio.h>

#include "..\inc\kernel.h"	// kernel API definitions.

#define MAXCHARS 500		// # chars to output/thread.
#define INVALID 0xffff		// invalid handle.

HANDLE LibraryMutex=INVALID;	// C library mutual exclusion handle.
HANDLE Trigger=INVALID;         // trigger event handle.
HANDLE Done1=INVALID;		// done1 event handle.
HANDLE Done2=INVALID;		// done2 event handle.
HANDLE Thread1=INVALID;         // thread1 handle.
HANDLE Thread2=INVALID;         // thread2 handle.

THREAD _loadds Thread1Func ()
{
    USHORT i;

    //
    // Wait for the main thread to tell us to start.
    //

    WaitEvent (Trigger);

    //
    // Write-out a few '1's on the screen.
    //

    for (i=0; i<MAXCHARS; i++) {
	AcquireMutex (LibraryMutex);
	putch ('1');
	ReleaseMutex (LibraryMutex);
    }

    //
    // Tell the main thread we are finished.
    //

    SetEvent (Done1);

    //
    // Deallocate this thread (the call never returns).
    //

    DeallocateThread ();
} // Thread1Func

THREAD _loadds Thread2Func ()
{
    USHORT i;

    //
    // Wait for the main thread to tell us to start.
    //

    WaitEvent (Trigger);

    //
    // Write-out a few '2's on the screen.
    //

    for (i=0; i<MAXCHARS; i++) {
	AcquireMutex (LibraryMutex);
	putch ('2');
	ReleaseMutex (LibraryMutex);
    }

    //
    // Tell the main thread we are finished.
    //

    SetEvent (Done2);

    //
    // Deallocate this thread (the call never returns).
    //

    DeallocateThread ();
} // Thread2Func

VOID main (int argc, char *argv[])
{

    printf ("This sample program has a main thread that allocates two\n");
    printf ("worker threads.  Each thread prints its thread number in\n");
    printf ("a loop %u times to show how preemption works in a simple\n", MAXCHARS);
    printf ("multithreaded system without prioritization.\n\n");

    AllocateMutex (&LibraryMutex);
    AllocateEvent (&Trigger);
    AllocateEvent (&Done1);
    AllocateEvent (&Done2);

    //
    // Allocate two worker threads and turn them loose together.
    //

    AllocateThread (Thread1Func);
    AllocateThread (Thread2Func);
    SetEvent (Trigger);

    //
    // Wait for both threads to complete.
    //

    WaitEvent (Done1);
    WaitEvent (Done2);

    //
    // Cleanup now.
    //

    DeallocateMutex (LibraryMutex);
    DeallocateEvent (Trigger);
    DeallocateEvent (Done1);
    DeallocateEvent (Done2);

    exit (0);			// successfully return to Embedded DOS.
} // mt1c.c
