# $Revision:   1.0  $
#
#************************************************************************
#
#   Title: Microsoft-compatible Makefile for MVI Barcode Sample
#
#   Environment:    1756-MVI Communications Module
#                   CIP API
#                   General Software DOS 6-XL
#                   Microsoft C/C++ Compiler (16-bit)
#
#   Author:     JMC
#               Copyright (c) 1999-2000 Online Development, Inc.
#
#************************************************************************

#----------------------------------------------
# Note: The environment variables LIB and
# INCLUDE must be set to the path to the
# Microsoft C library and include files.
# For example:
#
#    set LIB=D:\MSVC15\LIB
#    set INCLUDE=D:\MSVC15\INCLUDE
# 
#----------------------------------------------
# Paths to Tools
# 
# Note: Modify the following paths to
# correspond to your environment.
#
#----------------------------------------------
CPATH   = D:\MSVC15                 # Location of Microsoft tools
CC      = $(CPATH)\bin\cl           # compiler
LINK    = $(CPATH)\bin\link         # linker
MAKE    = $(CPATH)\bin\nmake        # make utility


#----------------------------------------------
# Path to API Libraries and Include files
# 
# Note: Modify the following paths to
# correspond to your environment.
#
#----------------------------------------------
CIPINC  = ..\include                  # Path to CIP API include file
CIPLIB  = ..\lib\cipapi.lib           # Path to CIP API library
SPINC   = ..\..\splib                 # Path to Serial Port include file
SPLIB   = ..\..\splib\mvispapi.lib    # Path to Serial Port API library
DOSLIB  = ..\..\doslib\kernel.lib     # Path to DOS kernel library
DOSINC  = ..\..\doslib                # Path to DOS include files


#----------------------------------------------
# Options
#----------------------------------------------
CFLAGS  = /c /nologo /G3 /W3 /AL /Oi /Gx- /I$(CIPINC) /I$(SPINC) /I$(DOSINC)
LFLAGS  = /MAP:A /NOI /PACKC


#----------------------------------------------
# Target Name
#----------------------------------------------
TARG    = bar_caio


#---------------------------------
# Library files
#---------------------------------
LIBS    =   $(CIPLIB) $(SPLIB) $(DOSLIB)


#----------------------------------------------
# Object files
#----------------------------------------------
OBJ     = $(TARG).obj 


#---------------------------------
# Final target
#---------------------------------
$(TARG).exe : $(OBJ) $(LIBS)
    $(LINK) $(LFLAGS) $(OBJ), $*.exe, $*.map, $(LIBS), nul.def

clean:
    del *.exe
    del *.obj
    del *.map

rebuild:
    $(MAKE) -f makefile.ms clean
    $(MAKE) -f makefile.ms

.c.obj:
    $(CC) $(CFLAGS) $*.c


$(TARG).obj: $(TARG).c makefile.ms



