;***	TIMER.INC -- Embedded DOS Timer Object.
;
;1.	Functional Description.
;	The following structure defines a timer object.  This object is
;	manipulated by the routines in TIMER.ASM.  All timer objects are
;	allocated from system pool, so they are all addressable in DOSDATA.
;	The TIMER object is not visible to kernel components that use the
;	TIMER object, but it is included here for the debugger.
;
;	Operations on timer objects are:
;	    AllocateTimer - Create timer and initialize it to the stopped state.
;	    FreeTimer - Stop timer and destroy it.
;	    StartTimer - [Re]Start a timer to expire at a specified delta time.
;	    StopTimer - Stop timer, even if already stopped.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	92/02/19.	#1.096, converted array -> list.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

TIMER		struc
timer_fwdlink	dw	?		; FWA, next timer object in system.
timer_timeout	dw	?		; # milliseconds 'till expiration.
timer_context	dw	?		; context value to pass to routine.
timer_ds	dw	?		; allocating thread's saved DS.
timer_rtn	dd	?		; FWA, routine to execute.
TIMER		ends
