;***	NCB.INC -- NetBIOS Control Block Definitions.
;
;1.	Functional Description.
;	This include file contains the structure definitions for the
;	NetBIOS Control Block (NCB) as submitted to the INT 5ch interface.
;
;2.	Modification History.
;	S. E. Jones	91/12/15.	#1.001, Original.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

NCB		STRUC
ncb_cmd         db	?		; command code.
ncb_status	db	?		; returned status code.
ncb_lsn         db	?		; local session number.
ncb_num         db	?		; name number.
ncb_buffer	dd	?		; 16:16 buffer pointer.
ncb_length	dw	?		; length of buffer in bytes.
ncb_remotename	db	16 dup (?)	; remote name.
ncb_localname	db	16 dup (?)	; local name.
ncb_rcvtimeout	db	?		; receive timeout in 500ms units.
ncb_sendtimeout db	?		; send timeout in 500ms units.
ncb_post	dd	?		; 16:16 post routine address (or 0 if none).
ncb_lana	db	?		; LAN adapter number.
ncb_complete	db	?		; completion command byte.

;	The following fields are reserved for the NetBIOS implementation
;	to use to manage this NCB's activity.  This area must be exactly
;	14 bytes long.

ncb_fwdlink	dd	?		; FWA, next NCB in chain.
ncb_ste         dw	?		; ofs FWA, STE associated with this NCB.
ncb_nte         dw	?		; ofs FWA, NTE associated with this NCB.
ncb_timeout	db	?		; 500ms units left before we time-out.
		db	(14-9) dup (?)	; reserved junk.
NCB		ENDS

;	The following fields are used by CHAIN.SEND and CHAIN.SEND.NO.ACK NCB's.

ncb_length2	=	ncb_remotename
ncb_buffer2	=	(ncb_remotename+2)

;	NCB command field definitions.	Used by themselves, all of these
;	commands are synchronous.  If the NCB_NOWAIT bit is set in the
;	command, then the NetBIOS interface returns immediately while the
;	request is processed.

NCB_ADD_GROUP_NAME	=	36h
NCB_ADD_NAME		=	30h
NCB_CALL		=	10h
NCB_CANCEL		=	35h
NCB_CHAIN_SEND		=	17h
NCB_CHAIN_SEND_NO_ACK	=	72h
NCB_DELETE_NAME         =	31h
NCB_FIND_NAME		=	78h
NCB_HANG_UP		=	12h
NCB_LAN_STATUS_ALERT	=	0f3h
NCB_LISTEN		=	11h
NCB_RECEIVE		=	15h
NCB_RECEIVE_ANY         =	16h
NCB_RECEIVE_BCST_DG	=	23h
NCB_RECEIVE_DG		=	21h
NCB_RESET		=	32h
NCB_SEND		=	14h
NCB_SEND_BCST_DG	=	22h
NCB_SEND_DG		=	20h
NCB_SESSION_STATUS	=	34h
NCB_STATUS		=	33h
NCB_TRACE		=	79h

NCB_NOWAIT		=	80h

;	Error codes in ncb_status.

NCBERR_SUCCESS		=	00h	; successful return.
NCBERR_INVALID_COMMAND	=	03h	; NCB invalid.
NCBERR_TIMEOUT		=	05h	; command timed out.
NCBERR_BAD_LSN		=	08h	; illegal LSN.
NCBERR_NO_RESOURCES	=	09h	; no NetBIOS resources available.
NCBERR_SESSION_CLOSED	=	0ah	; session was closed.
NCBERR_CANCELLED	=	0bh	; command was cancelled.
NCBERR_DUPLICATE_NAME	=	0dh	; duplicate name in local name table.
NCBERR_NAME_TABLE_FULL	=	0eh	; name table is full.
NCBERR_SESS_TABLE_FULL	=	11h	; session table is full.
NCBERR_NO_LISTENS	=	12h	; no listen at called name.
NCBERR_NO_ANSWER	=	14h	; can't find called name, or no answer.
NCBERR_NAME_NOT_FOUND	=	15h	; name isn't there, or '*' not appropriate.
NCBERR_NAME_IN_USE	=	16h	; name is already registered on the network.
NCBERR_SESSION_ABEND	=	18h	; session ended abnormally.
NCBERR_NAME_CONFLICT	=	19h	; name conflict detected.
NCBERR_INTERFACE_BUSY	=	21h	; NetBIOS is busy. try operation again.
NCBERR_TOO_MANY_CMDS	=	22h	; NetBIOS can't handle any more NCBs.
NCBERR_INVALID_LANA	=	23h	; adapter number invalid.
NCBERR_NEED_RESET	=	34h	; a RESET must be issued first.
NCBERR_NO_OS_RESOURCES	=	35h	; O/S resources exhausted, try again.
NCBERR_INVALID_NCB	=	39h	; bad NCB address, or invalid length.
