;***	FSRP.INC -- Embedded DOS File System Request Packet Structures.
;
;1.	Functional Description.
;	This include file contains the structure definitions for the
;	internal file system request packets used in Embedded DOS.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;	S. E. Jones	95/03/24.	#6-XL, added volume label bit.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

;***	FSRP - File System Request Packet.
;
;	This structure defines the layout of a File System Request Packet,
;	used as the basic control block to pass to FSD drivers.

FSRP		struc
fsrp_cmd	db	?		; IN command code.
fsrp_status	dw	?		; OUT FSD driver's return status code.

;	The following fields are used internally by Embedded DOS.

fsrp_linkage	dd	?		; pointer to next FSRP in chain.

;	The following are general IN/OUT parameters for the request.

fsrp_shte	dd	?		; IN FWA, SHTE for this request.
fsrp_buffer	dd	?		; IN OUT buffer pointer.
fsrp_pathname	dd	?		; IN offset FWA, major path.
fsrp_pathname2	dd	?		; IN offset FWA, second path (rename).
fsrp_count	dw	?		; IN OUT byte count value.
fsrp_flags	dw	?		; flags used to hold attributes, etc.
FSRP		ends

;	FSRP status bitflags and field masks.

FSRPSTATUS_ERROR =	8000h		; indicates error.
FSRPSTATUS_RETMASK=	00ffh		; error code if FSRPSTATUS_ERROR.

;	The following flags are used by the FSD_FILEINFO & FILETIME requests.

FSRP_FLAGS_SET	=	0001h		; if setting info, else getting info.

;	The following flags are used by the FSD_DELETEFILE request.

FSRP_FLAGS_VOLLABEL =	0001h		; delete a volume label.

;***	FSCTL - File System Control Request Packet.
;
;	This structure defines the layout of a File System Control Request
;	Packet, passed as an input parameter to the FSD_FILECTRL function
;	of the FSRP interface for FSDs.  Basically, this structure has a
;	few architected components at the beginning of the structure, and
;	then an extension that is unarchitected, except in the predefined
;	FSCTL functions.

FSCTL		struc
fsctl_cmd	dw	?		; command code (e.g., FSCTL_BLAH).
fsctl_hdrlen	dw	?		; length of the fixed part of the buffer.
fsctl_extbuf	dd	?		; FWA, extension buffer.
fsctl_extlen	dw	?		; length of extension buffer in bytes.

;	Do not define any fields beyond this point.  This is intended for
;	future expansion and is presently unarchitected.

FSCTL		ends
