/*
// PROGRAM NAME:  MSGPORT.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program is a simple example of how the executive message port
//	functions can be called from large-model C applications.  The program
//	creates a message port, and opens it with another handle, simulating
//	a second program that wishes to communicate with the first one.  Then,
//	a message is written to the first handle, and read from the second
//	handle.  The call to ExSendMsg is necessarily asynchronous so that
//	the ExReceiveMsg call can be executed in the example.
//
// MODIFICATION HISTORY.
//	S. E. Jones	93/09/18.	#1.106, original.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE ARGUMENTS.
//	none.
//
// NOTICE:  Copyright (C) 1993-1995 General Software, Inc.
*/

#define VOID void
#define UCHAR unsigned char
#define USHORT unsigned short
#define ULONG unsigned long
#define FALSE 0
#define TRUE (!FALSE)

#include <stdio.h>

#include "..\inc\message.h"	// message port API definitions.

#define MAXBUFLEN 128
static UCHAR Buf [MAXBUFLEN];
static UCHAR OutBuf [MAXBUFLEN];

VOID main (int argc, char *argv[])
{
    HANDLE Handle1, Handle2;
    USHORT len, i, BytesRead;

    printf ("This is a simple C program that uses message ports.\n");

    if (!ExCreateMsgPort ("Message_Server", &Handle1)) {
	printf ("The Message_Server port could not be created.\n");
	exit (-1);
    }

    if (!ExOpenMsgPort ("Message_Server", &Handle2)) {
	ExCloseMsgPort (Handle1);
	printf ("The Message_Server port could not be opened.\n");
	exit (-1);
    }

    strcpy (Buf, "This is a message.");
    len = strlen (Buf);

    if (!ExSendMsg (Handle1, Buf, len, MSG_FLAGS_BUFFER, 0)) {
	ExCloseMsgPort (Handle1);
	ExCloseMsgPort (Handle2);
	printf ("The message could not be sent.\n");
	exit (-1);
    }

    if (!ExReceiveMsg (Handle2, OutBuf, MAXBUFLEN, &BytesRead, MSG_FLAGS_WAIT, 0)) {
	ExCloseMsgPort (Handle1);
	ExCloseMsgPort (Handle2);
	printf ("The message could not be received.\n");
	exit (-1);
    }

    //
    // Compare what we sent with what we received.
    //

    if (BytesRead != len) {
	ExCloseMsgPort (Handle1);
	ExCloseMsgPort (Handle2);
	printf ("The message size was changed.\n");
	exit (-1);
    }

    for (i=0; i<len; i++) {
	if (Buf [i] != OutBuf [i]) {
	    ExCloseMsgPort (Handle1);
	    ExCloseMsgPort (Handle2);
	    printf ("The message was garbled.\n");
	    exit (-1);
	}
    }
    printf ("The message was successfully tranmitted & received.\n");

    //
    // Clean up and return to DOS.
    //

    ExCloseMsgPort (Handle1);	// close the message port handles.
    ExCloseMsgPort (Handle2);
    exit (0);			// successfully return to Embedded DOS.
} // msgport.c
