	TITLE	FCB - Simple FCB Test Program.

;***	FCB -- Simple FCB Test Program.
;
;1.	Functional Description.
;	This program illustrates how to call Embedded DOS FCB services
;	from an assembly-language program.  It simply calls DosFindFirstFcb
;	and DosFindNextFcb with an extended FCB to show a list of files
;	in the current directory.
;
;2.	Modification History.
;	S. E. Jones	95/02/18.	#2.2.19, original.
;	S. E. Jones	95/05/31.	#6-XL v30, removed extra def of DDE.INC.
;
;3.	NOTICE: Copyright (C) 1995 General Software, Inc.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

DO_EXTFCB	=	1		; 0=normal FCB, 1=ext FCB.

	include ..\inc\usegs.inc
	include ..\inc\udefines.inc
	include ..\inc\umacros.inc
	include ..\inc\ustruc.inc

	include ..\inc\kernel.inc

;	DOS call definitions.

	include ..\inc\dosapi.inc
	include ..\inc\doserr.inc

;	Define the stack.

_STACK	SEGMENT PARA STACK 'STACK'
	db	512 dup ('$')
TopStack =	$
_STACK	ENDS

UCODE	SEGMENT

Xfcb	label	word			; the extended FCB.
	IF	DO_EXTFCB
	db	0ffh			; signature byte.
	db	5 dup (0)		; reserved.
Attr	db	20h			; attribute for searches.
	ENDIF	; (DO_EXTFCB)
Drive	db	0			; default drive = 0.
	db	'???????????'		; the filename to scan for.
	dw	?			; current block number.
	dw	?			; current record size.
	db	4 dup (?)		; size of file, in bytes.
	dw	?			; file date.
	dw	?			; file time.
	db	8 dup (?)		; reserved bytes.
	db	?			; current record number.
	dd	?			; random record number.

UCODE	ENDS

UCODE	SEGMENT

;***	Main - Main Entrypoint.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is the entrypoint of the test program.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	95/02/18.	#2.2.19, original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Main, PUBLIC, FAR
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP		; (DS) = DGROUP.

;	Call DosFindFirstFcb, asking for all of the files on the default drive.

	mov	ah, DOSFINDFIRSTFCB	; (AH) = DOS function code.
	push	cs
	pop	ds
	lea	dx, CGROUP:Xfcb         ; (DS:DX) = FWA, extended FCB.
	int	21h			; fill-in the DTA.

Main_Loop:
	or	al, al			; was the operation successful?
	LJNE	Main_Exit		; if not.

	mov	ah, DOSGETDTA		; (AH) = DOS function code.
	int	21h			; (ES:BX) = FWA, DTA filled in by DOS.

;	Display the contents of the DTA.

	IF	DO_EXTFCB
	PRINTF	<Extended search FCB starts with $b\n>, <word ptr es:[bx]>
	add	bx, 7			; skip rest of extended header.
	ENDIF	; (DO_EXTFCB)

	PRINTF	<    Drive =  $b\n>, <word ptr es:[bx]>
	inc	bx			; (ES:BX) = FWA, DDE structure.

	PRINTF	<    Name  =  "$s[11]"\n>, <es, bx>
	PRINTF	<    Attr  =  $b\n>, <word ptr es:dde_flags.[bx]>
	PRINTF	<    Time  =  $x\n>, <word ptr es:dde_time.[bx]>
	PRINTF	<    Date  =  $x\n>, <word ptr es:dde_date.[bx]>
	PRINTF	<    Clust =  $x\n>, <word ptr es:dde_cluster.[bx]>
	PRINTF	<    Size  =  $lu\n>, <word ptr es:dde_size.[bx+0], \
				     word ptr es:dde_size.[bx+2]>
	PRINTF	<\n>

;	Find the next file in the list.

	mov	ah, DOSFINDNEXTFCB	; (AH) = DOS function code.
	push	cs
	pop	ds
	lea	dx, CGROUP:Xfcb         ; (DS:DX) = FWA, extended FCB.
	int	21h			; fill-in the DTA.
	jmp	Main_Loop		; do the rest.

;	Now terminate the program, returning to Embedded DOS.

Main_Exit:
	mov	ah, DOSEXIT
	mov	al, 0			; successful status code.
	int	21h			; terminate program.
EndProc Main

UCODE	ENDS
	END	Main
