;***	PTE.INC -- Embedded DOS Partition Table Entry.
;
;1.	Functional Description.
;	This structure defines the format of a partition table entry as
;	formatted in the Master Boot Record (MBR) of each disk spindle
;	in the system.	It is used by routines in DSKDEV.ASM during
;	system initialization, but is also made visible here for debugging.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/01/08.	Added XENIX & Concurrent DOS definitions.
;	S. E. Jones	91/01/11.	Added NW286, NW386, and mirroring.
;	S. E. Jones	92/01/05.	Added PCIX, Xenix bad block table.
;	S. E. Jones	92/05/22.	Added AFS, SYSV, RAW, SuperDOS.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;	D. K. Gibson	97/10/15.	#4.1, FIX last DD in PTE!
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

PTE		struc
pte_BootInd	db	?	; this is 80h for a bootable partition.
pte_FirstHead	db	?	; head number at start of partition.
pte_StartSectCyl dw	?	; low-order word sector number of PBR.
pte_SysInd	db	?	; system indicator.
pte_LastHead	db	?	; head number at end of partition.
pte_EndSectCyl	dw	?	; low-order word sector number of partition end.

pte_StartSect	dd	?	; starting relative sector number/this partition.

;	The first following line is CORRECT;  the next one is INCORRECT, but
;	temporarily preserved to allow the code to assemble!

;;pte_NumSect	dd	?	; NUMBER of sectors in this partition.
pte_EndSect	dd	?	; ending relative sector number/this partition.

PTE		ends

PTE_BOOTIND_BOOTABLE	=	80h	; value if partition is bootable.

PTE_SYSIND_UNKNOWN	=	00h	; unknown system type.
PTE_SYSIND_FAT12	=	01h	; DOS 1.x FAT partition, 12-bit FAT.
PTE_SYSIND_XENIX1	=	02h	; XENIX partition.
PTE_SYSIND_XENIX2	=	03h	; XENIX partition.
PTE_SYSIND_FAT16	=	04h	; DOS 2.x FAT partition, 16-bit FAT.
PTE_SYSIND_EXTDOS	=	05h	; DOS 3.x extended DOS partition.
PTE_SYSIND_BIGFAT	=	06h	; COMPAQ 3.31 & DOS 4.0 >32MB FAT partition.
PTE_SYSIND_FSD		=	07h	; non-FAT partition (OS/2 1.2-compatible).
PTE_SYSIND_UNIX_SYS_V	=	52h	; Unix System V I-node file system.
PTE_SYSIND_SCO_RAW	=	62h	; SCO Xenix raw partition.
PTE_SYSIND_SCO_AFS	=	63h	; Unix Acer Fast File System (SCO Unix).
PTE_SYSIND_NETWARE286	=	64h	; Novell NetWare 286.
PTE_SYSIND_NETWARE386	=	65h	; Novell NetWare 386.
PTE_SYSIND_PCIX         =	75h	; PC/IX.
PTE_SYSIND_MIRROR	=	87h	; OS/2 FT Mirror.
PTE_SYSIND_SUPERDOS	=	0aah	; SuperDOS file system.
PTE_SYSIND_MIRROR_DISAB =	0c7h	; diabled OS/2 FT Mirror.
PTE_SYSIND_CONCURRENT	=	0dbh	; Digital Research Concurrent DOS partition.
PTE_SYSIND_BADBLOCK	=	0ffh	; Xenix bad block table.
