//***	BPB.H -- BIOS Parameter Block Definition.
//
//1.	Functional Description.
//	This header file contains the definition for a BIOS Parameter Block.
//
//2.	Modification History.
//	S. E. Jones	95/03/17.	#6-XL, original.
//
//3.	NOTICE: Copyright (C) 1995 General Software, Inc.

#ifndef _BPBDEF_
#define _BPBDEF_

typedef struct _BPB {
    USHORT BytesPerSector;
    UCHAR SectorsPerCluster;
    USHORT ReservedSectors;
    UCHAR NumberOfFats;
    USHORT MaximumDirectoryEntries;
    USHORT TotalSectors16;
    UCHAR MediaDescriptor;
    USHORT SectorsPerFat;
    USHORT SectorsPerTrack;
    USHORT NumberOfHeads;

    //
    // The following two fields are extensions to the standard BPB.
    // If the TotalSectors16 field is zero, then TotalSectors32
    // contains the real extended total sectors.
    //

    ULONG HiddenSectors;		// hidden sectors (from MBR).
    ULONG TotalSectors32;		// extended total sectors.
} BPB, *PBPB;

#endif // _BPBDEF
