//***	SHTE.H -- System Handle Table Entry for C FSD Implementations.
//
//1.	Functional Description.
//	This include file contains structure definitions for use by
//	file system drivers (FSDs) written in C.
//
//2.	Modification History.
//	S. E. Jones	93/02/27.	#1.101, original.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1993-1995 General Software, Inc.

#ifndef _SHTE
#define _SHTE

//
// This structure defines the layout of a System Handle Table Entry,
// used as the basic control block to define open files in Embedded DOS.
//

typedef struct _SHTE {
    USHORT shte_sig;			// SHTE signature.

#define SHTE_SIGNATURE	0x4321		// if ==, this is an SHTE.

    USHORT shte_object;                 // object type.

#define SHTE_OBJECT_INV 0		// handle not completely defined.
#define SHTE_OBJECT_FSD 1		// handle opened to FSD-managed object.
#define SHTE_OBJECT_DEV 2		// handle opened to device-managed obj.

    USHORT shte_flags;			// flags, described below.

#define SHTE_FLAGS_FSDDEFINED 0x0001	// FSD field is meaningful.
#define SHTE_FLAGS_DEVDEFINED 0x0002	// DEV field is meaningful.
#define SHTE_FLAGS_LOCKED     0x0004	// SHTE is locked. read/write not permitted.
#define SHTE_FLAGS_RESERVED   0x0008	// this flag is unused.
#define SHTE_FLAGS_INHERIT    0x0010	// SHTE is inheritable.

    //
    // The following bogus flags are used by DosDevIoctl get/set device
    // information requests.
    //

#define SHTE_FLAGS_RAW	      0x0020	// handle is "raw", otherwise cooked.
#define SHTE_FLAGS_EOF	      0x0040	// handle is at EOF on input.
#define SHTE_FLAGS_WRITTEN    0x0080	// set if file has been written to.

    //
    // The following flags are used to keep track of device capabilities
    // for open and close functions.
    //

#define SHTE_FLAGS_OPENCLOSE  0x0100	// device driver supports open & close.
#define SHTE_FLAGS_CHAR       0x0200	// device driver implements a character device.

    //
    // Here are some more miscellaneous flags required for IOCTL.
    //

#define SHTE_FLAGS_NETWORK    0x0400	// this handle is remote (DFS or UNC).

    //
    // Here is more bogusness associated with "cooked" and "raw" I/O.
    // If an SHTE for a device is cooked and has the CONSOLE bit set,
    // then IOCON.ASM routines are used to handle the cooked I/O instead
    // of IoRead/IoWrite in IOSYS.ASM.
    //

#define SHTE_FLAGS_CONSOLE    0x0800	// this char driver is attached to the console.

    USHORT shte_handle;                 // internal ID maintained by FSD.
    PVOID shte_dev;			// FWA, device driver header.
    USHORT shte_fsd;			// seg adr, FSD driver.
    USHORT shte_sdte;			// offset ptr, SDTE if FSD covered drive.
    USHORT shte_refcount;		// number of open refs/this SHTE.
} SHTE, *PSHTE;

#endif // _SHTE
