/*****************************************************************************
*
*   Title:        Communications Module Serial Port Definitions
*
*   Abstract:     This file contains definitions and declarations
*                 needed for developing applications which use the
*                 MVI API.
*
*
*   Environment:  MVI Communications Module
*                 Borland/Microsoft C/C++ Compiler
*                 General Software Embedded DOS 6-XL
*
*   Author:       TEJ
*                 Copyright (c) 1999 Online Development, Inc.
*
*****************************************************************************/

#ifndef _MVISPAPI_H
#define _MVISPAPI_H

/*---------------------------------------------------------
**  The MVI Backplane API should be included before the
**  Serial Port API. It contains Error Result Codes and
**  common definitions used by both APIs. If the backplane
**  API is not used, use these definitions.
**-------------------------------------------------------*/
#ifndef _MVIBPAPI_H

/***********************************
**      TYPE DEFINITIONS
************************************/
typedef unsigned char   BYTE;       // 8-bit unsigned value
typedef unsigned short  WORD;       // 16-bit unsigned value
typedef unsigned long   DWORD;      // 32-bit unsigned value

/************************************
**    API FUNCTION RETURN CODES
*************************************/
#define MVI_SUCCESS             0       // Function returned successfully
#define MVI_ERR_BADPARAM        1       // A parameter is invalid
#define MVI_ERR_REOPEN          2       // Device is already open
#define MVI_ERR_NODEVICE        3       // Device is not present
#define MVI_ERR_NOACCESS        4       // Invalid access
#define MVI_ERR_TIMEOUT         5       // The function has timed out
#define MVI_ERR_MSGTOOBIG       6       // The message is too large
#define MVI_ERR_BADCONFIG       7       // The IO is not configured properly
#define MVI_ERR_MEMALLOC        8       // Unable to allocate memory

/* Library function declarations */
#ifdef __cplusplus
#define MVIAPIENTRY extern "C" int pascal
#define MVIAPIENTRYW extern "C" WORD pascal
#else
#define MVIAPIENTRY int pascal
#define MVIAPIENTRYW WORD pascal
#endif

#endif  /* ifndef _MVIBPAPI */

/***********************************
**  SERIAL PORT DEFINITIONS
************************************/

/* Com Ports */
#define     COM1            0
#define     COM2            1
#define     COM3            2
#define     COM4            3
#define     COM5            4

/* Baud Rates */
#define     BAUD_110        0
#define     BAUD_150        1
#define     BAUD_300        2
#define     BAUD_600        3
#define     BAUD_1200       4
#define     BAUD_2400       5
#define     BAUD_4800       6
#define     BAUD_9600       7
#define     BAUD_19200      8
#define     BAUD_28800      9
#define     BAUD_38400      10
#define     BAUD_57600      11
#define     BAUD_115200     12

/* Parity */
#define     PARITY_NONE     0
#define     PARITY_ODD      1
#define     PARITY_EVEN     2
#define     PARITY_MARK     3
#define     PARITY_SPACE    4

/* Word Length */
#define     WORDLEN5        0
#define     WORDLEN6        1
#define     WORDLEN7        2
#define     WORDLEN8        3

/* Stopbits */
#define     STOPBITS1       0
#define     STOPBITS2       1

/* Handshaking Modes */
#define     HSHAKE_NONE     0x00
#define     HSHAKE_RTSCTS   0x01
#define     HSHAKE_DTRDSR   0x02
#define     HSHAKE_XONXOFF  0x04

/************************************
**  VERSION INFORMATION STRUCT
*************************************/
typedef struct tagMVISPVERSIONINFO
{
    WORD    APISeries;
    WORD    APIRevision;
} MVISPVERSIONINFO;

/************************************
**  MVISPALTSETUP STRUCT
*************************************/
typedef struct tagMVISPALTSETUP
{
    BYTE    baudrate;
    BYTE    parity;
    BYTE    wordlen;
    BYTE    stopbits;
    int     txquesize;      /* Transmit que size */
    int     rxquesize;      /* Receive que size  */
    BYTE    fifosize;       /* UART FIFO size */
} MVISPALTSETUP;

/***********************************
**  OTHER DEFINITIONS
************************************/

/* States for RTS/CTS/DTR/DSR/DCD */
#define     ON              1
#define     OFF             0

/* Timeout values */
#define     TIMEOUT_ASAP    0
#define     TIMEOUT_FOREVER 0xFFFFFFFFL

/* Line Status Errors */
#define     QSERR_OVERRUN   0x01    /* Queue Overrun Error  */
#define     LSERR_OVERRUN   0x02    /* UART Overrun Error   */
#define     LSERR_PARITY    0x04    /* Parity Error         */
#define     LSERR_FRAMING   0x08    /* Framing Error        */
#define     LSERR_BREAK     0x10    /* Break Interrupt      */

/* A few ASCII codes */
#define     _CR             0x0D    /* Carriage Return (^M, Ascii 13) */
#define     _LF             0x0A    /* Line Feed (^J, Ascii 10) */
#define     _ESC            0x1B    /* Escape (^[, Ascii 27) */
#define     _BEL            0x07    /* Bell (^G, Ascii 7) */
#define     _XON            0x11    /* XON (DC3, ^Q, Ascii 17) */
#define     _XOFF           0x13    /* XOFF (DC1, ^S, Ascii 19) */

/* Que Sizes */
#define     MINQSIZE        512     /* Minimum Que Size */
#define     DEFQSIZE            1024    /* Default Que Size */
#define     MAXQSIZE        16384   /* Maximum Que Size */

/* Select Port Resource Actions */
#define     SELPTRES_GET    0       /* Get Port Resources */
#define     SELPTRES_SET    1       /* Set Port Resources */
#define     SELPTRES_DEF    2       /* Set Port Resources to defaults */
#define     SELPTRES_REM    3       /* Disable Port Resources */

/* UART FIFO Sizes */
/* If the UART does not contain a FIFO, the fifosize is ignored.
** If it does have a FIFO, the TX FIFO is fixed at 16 chars and
** the RX FIFO will be set according to this FIFO setting.
*/
#define     FIFO_DISABLED   0       /* disable FIFO for both Transmit & Receive */
#define     RXFIFO_SIZ1     1       /* Que data when UART RX FIFO contains 1 or more chars */
#define     RXFIFO_SIZ4     2       /* Que data when UART RX FIFO contains 4 or more chars */
#define     RXFIFO_SIZ8     3       /* Que data when UART RX FIFO contains 8 or more chars */
#define     RXFIFO_SIZ14    4       /* Que data when UART RX FIFO contains 14 or more chars */
#define     RXFIFO_DEFAULT  RXFIFO_SIZ8 /* default is 8 */

/************************************
**  API FUNCTION RETURN CODES
*************************************/
/* See mvibpapi.h */

/*************************************
**  API FUNCTION PROTOTYPES
*************************************/

MVIAPIENTRY MVIsp_Open(int comport, BYTE baudrate, BYTE parity, BYTE wordlen, BYTE stopbits);
MVIAPIENTRY MVIsp_OpenAlt(int comport, MVISPALTSETUP *altsetup);
MVIAPIENTRY MVIsp_Close(int comport);
MVIAPIENTRY MVIsp_Config(int comport, BYTE baudrate, BYTE parity, BYTE wordlen, BYTE stopbits);
MVIAPIENTRY MVIsp_SetRTS(int comport, int state);
MVIAPIENTRY MVIsp_GetRTS(int comport, int *state);
MVIAPIENTRY MVIsp_SetDTR(int comport, int state);
MVIAPIENTRY MVIsp_GetDTR(int comport, int *state);
MVIAPIENTRY MVIsp_GetCTS(int comport, int *state);
MVIAPIENTRY MVIsp_GetDSR(int comport, int *state);
MVIAPIENTRY MVIsp_GetDCD(int comport, int *state);
MVIAPIENTRY MVIsp_GetRI(int comport, int *state);
MVIAPIENTRY MVIsp_GetUartType(int comport, int *);
MVIAPIENTRY MVIsp_Putch(int comport, BYTE ch, DWORD timeout);
MVIAPIENTRY MVIsp_Puts(int comport, BYTE *str, BYTE term, int *len, DWORD timeout);
MVIAPIENTRY MVIsp_PutData(int comport, BYTE *data, int *len, DWORD timeout);
MVIAPIENTRY MVIsp_Getch(int comport, BYTE *ch, DWORD timeout);
MVIAPIENTRY MVIsp_Gets(int comport, BYTE *str, BYTE term, int *len, DWORD timeout);
MVIAPIENTRY MVIsp_GetData(int comport, BYTE *data, int *len, DWORD timeout);
MVIAPIENTRY MVIsp_GetCountUnsent(int comport, int *count);
MVIAPIENTRY MVIsp_GetCountUnread(int comport, int *count);
MVIAPIENTRY MVIsp_SetHandshaking(int comport, int shake);
MVIAPIENTRY MVIsp_GetVersionInfo(MVISPVERSIONINFO *verinfo);
MVIAPIENTRY MVIsp_GetLineStatus(int comport, BYTE *status);
MVIAPIENTRY MVIsp_PurgeDataUnsent(int comport);
MVIAPIENTRY MVIsp_PurgeDataUnread(int comport);
MVIAPIENTRY MVIsp_SelectPortResources(int comport, int Action, WORD *BaseAddr, int *Irq);


#endif

