;***	SEGMENTS.INC -- Embedded DOS Segment Declarations.
;
;1.	Functional Description.
;	This include file defines the segments used in Embedded DOS.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/05/20.	Added OEMCODE.
;	S. E. Jones	92/01/08.	#1.095, added I/O helper API.
;	S. E. Jones	92/07/26.	#1.099, added OBJECTCODE.
;	S. E. Jones	93/09/10.	#1.106, TASM: CONST->_CONST, STACK->_STACK.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	94/04/28.	#2.1, removed DFSCODE.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

_CONST	SEGMENT WORD PUBLIC 'CONST'
_CONST	ENDS

_BSS	SEGMENT WORD PUBLIC 'BSS'
_BSS	ENDS

_DATA	SEGMENT WORD PUBLIC 'DATA'
_DATA	ENDS

DBGMSG	SEGMENT WORD PUBLIC 'DATA'
DBGMSG	ENDS

MSG	SEGMENT WORD PUBLIC 'DATA'
MSG	ENDS

TESTDATA SEGMENT WORD PUBLIC 'DATA'
TESTDATA ENDS

DGROUP	GROUP	_CONST, _BSS, _DATA, DBGMSG, MSG, TESTDATA

_STACK	SEGMENT PARA STACK 'STACK'
_STACK	ENDS

KPRINTFCODE SEGMENT WORD PUBLIC 'CODE'	; formatted output for debugger, etc.
KPRINTFCODE ENDS

ERRORCODE SEGMENT WORD PUBLIC 'CODE'	; error reporting/recovery.
ERRORCODE ENDS

DOSCODE SEGMENT WORD PUBLIC 'CODE'	; int 21 functions.
DOSCODE ENDS

IOCODE SEGMENT WORD PUBLIC 'CODE'	; I/O subsystem.
IOCODE ENDS

OBJECTCODE SEGMENT WORD PUBLIC 'CODE'	; named object package.
OBJECTCODE ENDS

THREADCODE SEGMENT WORD PUBLIC 'CODE'	; thread object package.
THREADCODE ENDS

MUTEXCODE SEGMENT WORD PUBLIC 'CODE'	; mutex object package.
MUTEXCODE ENDS

EVENTCODE SEGMENT WORD PUBLIC 'CODE'	; event object package.
EVENTCODE ENDS

FSHELPCODE SEGMENT WORD PUBLIC 'CODE'	; FSD system helpers.
FSHELPCODE ENDS

IOHELPCODE SEGMENT WORD PUBLIC 'CODE'	; IO help system helpers.
IOHELPCODE ENDS

ISRCODE SEGMENT WORD PUBLIC 'CODE'	; interrupt service routines.
ISRCODE ENDS

POOLCODE SEGMENT WORD PUBLIC 'CODE'	; system memory pool manager routines.
POOLCODE ENDS

TIMERCODE SEGMENT WORD PUBLIC 'CODE'	; system timer manager routines.
TIMERCODE ENDS

PRINTCODE SEGMENT WORD PUBLIC 'CODE'	; task-time print spooler.
PRINTCODE ENDS

INITCODE SEGMENT WORD PUBLIC 'CODE'	; initialization code.
INITCODE ENDS

OEMCODE SEGMENT WORD PUBLIC 'CODE'	; OEM-specific code.
OEMCODE ENDS

CODEDATA SEGMENT WORD PUBLIC 'CODE'	; static ugly data in the code seg.
CODEDATA ENDS

TESTCODE SEGMENT WORD PUBLIC 'CODE'	; system testing code.
TESTCODE ENDS

AUXCODE SEGMENT WORD PUBLIC 'CODE'	; async device driver code.
AUXCODE ENDS

PRNCODE SEGMENT WORD PUBLIC 'CODE'	; printer device driver code.
PRNCODE ENDS

CONCODE SEGMENT WORD PUBLIC 'CODE'	; console device driver code.
CONCODE ENDS

DSKCODE SEGMENT WORD PUBLIC 'CODE'     ; disk device driver code.
DSKCODE ENDS

CLKCODE SEGMENT WORD PUBLIC 'CODE'     ; clock device driver code.
CLKCODE ENDS

NULCODE SEGMENT WORD PUBLIC 'CODE'     ; NUL device driver code.
NULCODE ENDS


CGROUP GROUP KPRINTFCODE,ISRCODE,THREADCODE,EVENTCODE,TIMERCODE,MUTEXCODE,\
 POOLCODE,OBJECTCODE,IOHELPCODE,FSHELPCODE,ERRORCODE,DOSCODE,IOCODE,CODEDATA,\
 TESTCODE,INITCODE,OEMCODE,PRINTCODE,PRNCODE,AUXCODE,CONCODE,DSKCODE,\
 CLKCODE,NULCODE

;	The following segment is defined "AT 0" to indicate that no actual
;	objects should be written to the .ABS file; rather, only a template
;	is defined whereby we can ASSUME a segment register to this segment
;	and we can refer to the objects in a dynamically allocated segment
;	(the dynamic allocation is done in SYSINIT.ASM).

DOSDATA SEGMENT AT 0
DOSDATA ENDS
