//***	ODE.H -- Object Directory Entry Definitions.
//
//1.	Functional Description.
//
//2.	Modification History.
//	G. A. Blanchard 93/03/14.	#1.101 Original.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1993-1995 General Software, Inc.

#define ODE_NAME_SIZE	64

typedef struct _ODE {
    USHORT ode_handle;			// system handle used in search.
    USHORT ode_type;			// type of object returned.
    UCHAR ode_host [8];                 // ASCIIZ host name.
    ULONG ode_dirsec;			// sector # containing DDE.
    USHORT ode_dirofs;			// offset of DDE within sector.
    USHORT ode_fileid;			// for FAT, 1st cluster of file.
    UCHAR ode_access;			// used internally by Embedded DOS.
    UCHAR ode_attrib;			// attribute of object.
    USHORT ode_time;			// time stamp.
    USHORT ode_date;			// date stamp.
    ULONG ode_size;			// size of object in bytes.
    UCHAR ode_name [ODE_NAME_SIZE];	// DOS uses 13, but we extend it.
} ODE, *PODE;

#define ODE_TYPE_FILE		0	// file/directory/volume label.
#define ODE_TYPE_MSGPORT	1	// RPC port.

#define ODE_ACCESS_READ         0x01	// read access permitted.
#define ODE_ACCESS_WRITE	0x02	// write access permitted.
#define ODE_ACCESS_EXEC         0x04	// execute access permitted.
#define ODE_ACCESS_DELETE	0x08	// delete access permitted.

#define ODE_FLAGS_READONLY	0x01	// object is read only.
#define ODE_FLAGS_HIDDEN	0x02	// object is hidden.
#define ODE_FLAGS_SYSTEM	0x04	// object is system object.
#define ODE_FLAGS_VOLUME_LABEL	0x08	// object is volume label.
#define ODE_FLAGS_DIRECTORY	0x10	// object is directory.
#define ODE_FLAGS_ARCHIVE	0x20	// object has not been backed up.
