VERSION 5.00
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCT2.OCX"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form frmMain 
   Caption         =   "PC56 Historian Get Data Wizard"
   ClientHeight    =   8820
   ClientLeft      =   630
   ClientTop       =   825
   ClientWidth     =   8250
   LinkTopic       =   "Form1"
   ScaleHeight     =   8820
   ScaleWidth      =   8250
   Begin MSComCtl2.MonthView mvDate 
      Height          =   2310
      Left            =   1320
      TabIndex        =   19
      Top             =   4800
      Visible         =   0   'False
      Width           =   2640
      _ExtentX        =   4657
      _ExtentY        =   4075
      _Version        =   393216
      ForeColor       =   -2147483630
      BackColor       =   -2147483633
      Appearance      =   0
      StartOfWeek     =   24838145
      CurrentDate     =   38450
   End
   Begin VB.Frame frameData 
      Caption         =   "Retrieved Data"
      Enabled         =   0   'False
      Height          =   2295
      Left            =   240
      TabIndex        =   29
      Top             =   6240
      Visible         =   0   'False
      Width           =   7695
      Begin MSFlexGridLib.MSFlexGrid fgData 
         Height          =   1815
         Left            =   240
         TabIndex        =   32
         Top             =   300
         Width           =   5415
         _ExtentX        =   9551
         _ExtentY        =   3201
         _Version        =   393216
         HighLight       =   0
         ScrollBars      =   2
      End
      Begin VB.CommandButton cmdRetrievedDataWT 
         Caption         =   "What's This?"
         Height          =   315
         Left            =   5940
         TabIndex        =   31
         Top             =   1620
         Width           =   1335
      End
      Begin VB.CommandButton cmdStartAgain 
         Caption         =   "Start Again!"
         Height          =   315
         Left            =   5940
         TabIndex        =   30
         Top             =   1080
         Width           =   1335
      End
   End
   Begin VB.Frame frameDataRange 
      Caption         =   "Step 4: Select Desired Data Range"
      Height          =   2295
      Left            =   240
      TabIndex        =   12
      Top             =   3720
      Visible         =   0   'False
      Width           =   7695
      Begin VB.Frame frameDateOptions 
         Caption         =   "Options"
         Height          =   1395
         Left            =   240
         TabIndex        =   18
         Top             =   720
         Width           =   5475
         Begin MSComCtl2.UpDown UpDown1 
            Height          =   315
            Left            =   4500
            TabIndex        =   27
            Top             =   840
            Width           =   495
            _ExtentX        =   873
            _ExtentY        =   556
            _Version        =   393216
            Value           =   10
            BuddyControl    =   "txtPoints"
            BuddyDispid     =   196614
            OrigLeft        =   5400
            OrigTop         =   840
            OrigRight       =   5955
            OrigBottom      =   1155
            Max             =   100
            Min             =   1
            Orientation     =   1
            SyncBuddy       =   -1  'True
            BuddyProperty   =   65547
            Enabled         =   -1  'True
         End
         Begin VB.TextBox txtPoints 
            Height          =   315
            Left            =   3780
            Locked          =   -1  'True
            TabIndex        =   26
            Text            =   "10"
            Top             =   840
            Width           =   720
         End
         Begin VB.OptionButton optDataBefore 
            Caption         =   "Data Before"
            Height          =   255
            Left            =   3780
            TabIndex        =   25
            Top             =   540
            Width           =   1395
         End
         Begin VB.OptionButton optDataAfter 
            Caption         =   "Data After"
            Height          =   255
            Left            =   3780
            TabIndex        =   24
            Top             =   240
            Value           =   -1  'True
            Width           =   1215
         End
         Begin VB.TextBox txtTime 
            Height          =   315
            Left            =   840
            TabIndex        =   23
            Top             =   840
            Width           =   1695
         End
         Begin VB.TextBox txtDate 
            Height          =   315
            Left            =   840
            Locked          =   -1  'True
            TabIndex        =   20
            Top             =   360
            Width           =   1695
         End
         Begin VB.Label Label3 
            Caption         =   "Values:"
            Height          =   255
            Left            =   3060
            TabIndex        =   28
            Top             =   900
            Width           =   615
         End
         Begin VB.Label Label2 
            Caption         =   "Time:"
            Height          =   255
            Left            =   240
            TabIndex        =   22
            Top             =   900
            Width           =   435
         End
         Begin VB.Label Label1 
            Caption         =   "Date:"
            Height          =   255
            Left            =   240
            TabIndex        =   21
            Top             =   420
            Width           =   495
         End
      End
      Begin VB.OptionButton optFirstVal 
         Caption         =   "First Values"
         Height          =   375
         Left            =   3780
         TabIndex        =   17
         Top             =   360
         Width           =   1215
      End
      Begin VB.OptionButton optLastVal 
         Caption         =   "Last Values"
         Height          =   315
         Left            =   2100
         TabIndex        =   16
         Top             =   360
         Width           =   1215
      End
      Begin VB.OptionButton optDate 
         Caption         =   "Date Selection"
         Height          =   315
         Left            =   300
         TabIndex        =   15
         Top             =   360
         Value           =   -1  'True
         Width           =   1575
      End
      Begin VB.CommandButton cmdReadyDataRange 
         Caption         =   "Ready!"
         Height          =   315
         Left            =   5940
         TabIndex        =   14
         Top             =   1080
         Width           =   1335
      End
      Begin VB.CommandButton cmdDataRangeWT 
         Caption         =   "What's This?"
         Height          =   315
         Left            =   5940
         TabIndex        =   13
         Top             =   1620
         Width           =   1335
      End
   End
   Begin VB.Frame frameDataStreams 
      Caption         =   "Step 3: Select Desired Data Stream"
      Height          =   915
      Left            =   240
      TabIndex        =   8
      Top             =   2580
      Visible         =   0   'False
      Width           =   7695
      Begin VB.ComboBox cmbDataStreams 
         Height          =   315
         Left            =   240
         Style           =   2  'Dropdown List
         TabIndex        =   11
         Top             =   360
         Width           =   4095
      End
      Begin VB.CommandButton cmdDataStreamWT 
         Caption         =   "What's This?"
         Height          =   315
         Left            =   6000
         TabIndex        =   10
         Top             =   360
         Width           =   1335
      End
      Begin VB.CommandButton cmdReadyDataStreams 
         Caption         =   "Ready!"
         Height          =   315
         Left            =   4560
         TabIndex        =   9
         Top             =   360
         Width           =   1335
      End
   End
   Begin VB.Frame frameHistorian 
      Caption         =   "Step 2: Select Desired Historian"
      Height          =   915
      Left            =   240
      TabIndex        =   4
      Top             =   1440
      Visible         =   0   'False
      Width           =   7695
      Begin VB.CommandButton cmdReadyHistorian 
         Caption         =   "Ready!"
         Height          =   315
         Left            =   4560
         TabIndex        =   7
         Top             =   360
         Width           =   1335
      End
      Begin VB.CommandButton cmdHistorianWT 
         Caption         =   "What's This?"
         Height          =   315
         Left            =   6000
         TabIndex        =   6
         Top             =   360
         Width           =   1335
      End
      Begin VB.ComboBox cmbHistorians 
         Height          =   315
         Left            =   240
         Style           =   2  'Dropdown List
         TabIndex        =   5
         Top             =   360
         Width           =   4095
      End
   End
   Begin VB.Frame frameNodeName 
      Caption         =   "Step 1: Enter the PC56-HIST Node Name"
      Height          =   915
      Left            =   240
      TabIndex        =   0
      Top             =   300
      Width           =   7695
      Begin VB.CommandButton cmdNodeWT 
         Caption         =   "What's This?"
         Height          =   315
         Left            =   6000
         TabIndex        =   3
         Top             =   360
         Width           =   1335
      End
      Begin VB.CommandButton cmdReadyNodeName 
         Caption         =   "Ready!"
         Height          =   315
         Left            =   4560
         TabIndex        =   2
         Top             =   360
         Width           =   1335
      End
      Begin VB.TextBox txtNodeName 
         Height          =   315
         Left            =   240
         TabIndex        =   1
         Text            =   "PC56-2K-IDE-01"
         Top             =   360
         Width           =   4095
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'************************************************************
' Title: Sample Wizard to Get Data from a PC56-HISTORIAN
'
' Environment:  Windows NT 4, 2000, or XP
'               Microsoft Visual Basic
'
' Copyright (c) 2004-2005 Prosoft Technology, Inc.
' Iaki Zuloaga
'
'  Abstract:
'
'  This program may serve as a starting point or an example
'  To retrieve data form a PC56-HIST ECHO Database
'
'
'  ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
'  and re-distribute this program provided that this copyright notice and
'  license appear on all copies of the software.
'
'  Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
'  IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
'  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
'  HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
'  BY THE LICENSEE.
'
'  PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
'  DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
'  DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
'  LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
'  INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
'  CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
'  OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
'  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
'
'************************************************************


Option Explicit

'This is the Name of the PC56-HIST computer on the
'Domain
Dim strECHOServerName As String
Dim strSelectedHistorian As String
Dim strSelectedDataStream As String


Dim objCHNode As Object
Dim objCHHistorians As Object
Dim objCHHistorian As Object
Dim objCHDataStreams As Object
Dim objCHDataStream As Object
Dim objCHDataIterator As Object
Dim objCHTime As Object







Private Sub cmdDataRangeWT_Click()
   MsgBox "You can select the date/time range of the values to retrieve from the PC56-HIST." + vbCrLf + _
          "Select a Data Range to retrieve." & vbCrLf _
          , vbOKOnly, "What's the Data Range?"

End Sub

Private Sub cmdDataStreamWT_Click()
   MsgBox "On the PC56-HIST each Data Stream holds the historical data of one TAG" + vbCrLf + _
          "Select a Data Stream to take data from." & vbCrLf _
          , vbOKOnly, "What's a Data Stream?"

End Sub

Private Sub cmdHistorianWT_Click()
   MsgBox "Each Historian is like a Data Repository where you can store" + vbCrLf + _
          "one or more Data Streams." & vbCrLf & _
          "Select the Historian to take data from.", vbOKOnly, "What's a Historian?"

End Sub

Private Sub cmdNodeWT_Click()
   MsgBox "This is the name of the PC56-HIST on the Network." + vbCrLf + _
          "The PC56-HIST needs to be configured on the same Domain as this PC", vbOKOnly, "What's the Node Name?"
          
   
End Sub

Private Sub cmdReadyDataRange_Click()
   Dim i As Integer
   'Ste the Grid to the Right Size
   fgData.Rows = Val(txtPoints) + 1
   
   On Error GoTo GetDataError
   
   'Get the selected Data Stream
   Set objCHDataStream = objCHNode.getchdatastream(strSelectedDataStream)
   ' Refresh so the values are updated
   objCHDataStream.Refresh
   'Check if there's data on the selected Data Stream
   If Not objCHDataStream.HasData Then
      MsgBox "The Selected Data Stream doesn't contain data.", vbExclamation, "Retrieved Data"
      frameNodeName.Enabled = False
      frameHistorian.Enabled = False
      frameDataStreams.Enabled = False
      frameDataRange.Enabled = False
      frameData.Enabled = True
      frameData.Visible = True
      Exit Sub
   End If
   
   'Setup the Data Iterator, object needed to search
   'trough the Data values
   Set objCHDataIterator = objCHDataStream.Iterator
   
   If optDate.Value Then
      Dim selectedTime As Date
      selectedTime = txtDate & " " & txtTime
      'Create the Time Object needed to search data using a
      'date and time
      Set objCHTime = CreateObject("CHSDK.CHTime")
      'Selected the desired Date and Time
      objCHTime = selectedTime
      If optDataAfter Then
         'Got to the Data Value pointed by tje objCHTime object
         ' The second Parameter is:
         ' 1 = Data Before
         ' 2 = Data At and Before
         ' 3 = Data At
         ' 4 = Data At and After
         ' 5 = Data After
         objCHDataIterator.MoveUsingCHTime objCHTime, 5
         'Read the Data Points
         For i = 1 To Val(txtPoints)
            fgData.TextMatrix(i, 0) = objCHDataIterator.Data.CHTimestamp.LocalDate
            fgData.TextMatrix(i, 1) = objCHDataIterator.Data.Value
            objCHDataIterator.MoveNext
         Next i
      ElseIf optDataBefore Then
         objCHDataIterator.MoveUsingCHTime objCHTime, 1
         For i = 1 To Val(txtPoints)
            fgData.TextMatrix(i, 0) = objCHDataIterator.Data.CHTimestamp.LocalDate
            fgData.TextMatrix(i, 1) = objCHDataIterator.Data.Value
            objCHDataIterator.MovePrev
         Next i
      End If
      
   
   
   ElseIf optLastVal.Value Then
      ' Move to Last value to obtain the Last Available values
      objCHDataIterator.MoveLast
      For i = 1 To Val(txtPoints)
         fgData.TextMatrix(i, 0) = objCHDataIterator.Data.CHTimestamp.LocalDate
         fgData.TextMatrix(i, 1) = objCHDataIterator.Data.Value
         objCHDataIterator.MovePrev
      Next i
   ElseIf optFirstVal.Value Then
      ' Move to the first value
      objCHDataIterator.MoveFirst
      For i = 1 To Val(txtPoints)
         fgData.TextMatrix(i, 0) = objCHDataIterator.Data.CHTimestamp.LocalDate
         fgData.TextMatrix(i, 1) = objCHDataIterator.Data.Value
         objCHDataIterator.MoveNext
      Next i
   End If
   
   frameNodeName.Enabled = False
   frameHistorian.Enabled = False
   frameDataStreams.Enabled = False
   frameDataRange.Enabled = False
   frameData.Enabled = True
   frameData.Visible = True
   
   Exit Sub
   
GetDataError:

   frameNodeName.Enabled = False
   frameHistorian.Enabled = False
   frameDataStreams.Enabled = False
   frameDataRange.Enabled = False
   frameData.Enabled = True
   frameData.Visible = True
   
   MsgBox "There has been an error retrieving data from the PC56-HIST" & vbCrLf & _
          "Make sure the requested data exists." & vbCrLf & _
          "Error Detailed Message: " & vbCrLf & _
          Err.Description, vbCritical, "Get Data Error!"
          
      
End Sub

Private Sub cmdReadyDataStreams_Click()


   strSelectedDataStream = cmbDataStreams.Text
   If strSelectedDataStream = "" Then
      MsgBox "You need to select a Data Stream from the list.", vbExclamation, "Data Stream Selection"
      Exit Sub
   End If

   frameDataRange.Enabled = True
   optDataAfter = True
   txtDate = Date
   txtTime = Time
   optLastVal = True
   
   frameNodeName.Enabled = False
   frameHistorian.Enabled = False
   frameDataStreams.Enabled = False
   frameDataRange.Enabled = True
   frameDataRange.Visible = True
   
   
   

End Sub

Private Sub cmdReadyHistorian_Click()
   strSelectedHistorian = cmbHistorians.Text
   If strSelectedHistorian = "" Then
      MsgBox "You need to select a Historian from the list.", vbExclamation, "Historian Selection"
      Exit Sub
   End If
   
   'Get the selected Historian
   Set objCHHistorian = objCHNode.GetCHHistorian(strSelectedHistorian)
   'Get all the available Data Stream on the Historian
   Set objCHDataStreams = objCHHistorian.CHDataStreams
   'List all the Data Streams
   For Each objCHDataStream In objCHDataStreams
      cmbDataStreams.AddItem objCHDataStream.Name
      Set objCHDataStream = Nothing
   Next objCHDataStream

   frameNodeName.Enabled = False
   frameHistorian.Enabled = False
   frameDataStreams.Enabled = True
   frameDataStreams.Visible = True
End Sub

Private Sub cmdReadyNodeName_Click()
   On Error GoTo ConnectionError
   strECHOServerName = txtNodeName.Text
   'Create the ECHO Historian Node Object
   Set objCHNode = CreateObject("CHSDK.CHNode")
   'Connect to the selected ECHO Historian Node
   objCHNode.Connect strECHOServerName
   'Get the available Historians on that ECHO Node
   Set objCHHistorians = objCHNode.CHHistorians
   
   'List all the available Historians on the selected Node
   For Each objCHHistorian In objCHHistorians
      cmbHistorians.AddItem objCHHistorian.Name
      Set objCHHistorian = Nothing
   Next objCHHistorian

   frameNodeName.Enabled = False
   frameHistorian.Enabled = True
   frameHistorian.Visible = True
   
   Exit Sub
   
ConnectionError:
   MsgBox "There has been a connection error with the PC56-HIST" & vbCrLf & _
          "Check the Node Name and make sure the PC56-HIST is configured in the Domain and try again" & vbCrLf & _
          "Error Detailed Message: " & vbCrLf & _
          Err.Description, vbCritical, "Connection Error!"
          
   
End Sub


Private Sub cmdRetrievedDataWT_Click()
   MsgBox "This are the retrieved timestamped data values from the PC56-HIST" + vbCrLf + _
          "Review the data and start again.." & vbCrLf _
          , vbOKOnly, "What's the retrieved data?"

End Sub

Private Sub cmdStartAgain_Click()
   frameNodeName.Enabled = True
   frameHistorian.Enabled = False
   frameDataStreams.Enabled = False
   frameDataRange.Enabled = False
   frameData.Enabled = False
   
   frameNodeName.Visible = True
   frameHistorian.Visible = False
   frameDataStreams.Visible = False
   frameDataRange.Visible = False
   frameData.Visible = False
   
 
   Set objCHNode = Nothing
   Set objCHHistorians = Nothing
   Set objCHHistorian = Nothing
   Set objCHDataStreams = Nothing
   Set objCHDataStream = Nothing
   Set objCHDataIterator = Nothing
   Set objCHTime = Nothing
 
   fgData.ColWidth(0) = 2500
   fgData.ColWidth(1) = 2500
   fgData.TextMatrix(0, 0) = "TIMESTAMP"
   fgData.TextMatrix(0, 1) = "VALUE"
   fgData.Col = 0
   fgData.Row = 0
   fgData.CellAlignment = flexAlignCenterCenter
   fgData.Col = 1
   fgData.Row = 0
   fgData.CellAlignment = flexAlignCenterCenter
   fgData.Rows = 10
   
   cmbHistorians.Clear
   cmbDataStreams.Clear
   
End Sub

Private Sub Form_Load()
   frameNodeName.Enabled = True
   frameHistorian.Enabled = False
   frameDataStreams.Enabled = False
   frameDataRange.Enabled = False
   frameData.Enabled = False
   
   
 
   fgData.ColWidth(0) = 2500
   fgData.ColWidth(1) = 2500
   fgData.TextMatrix(0, 0) = "TIMESTAMP"
   fgData.TextMatrix(0, 1) = "VALUE"
   fgData.Col = 0
   fgData.Row = 0
   fgData.CellAlignment = flexAlignCenterCenter
   fgData.Col = 1
   fgData.Row = 0
   fgData.CellAlignment = flexAlignCenterCenter
   fgData.Rows = 10
   
   
   
End Sub


Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  mvDate.Visible = False

End Sub


Private Sub frameDataRange_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  mvDate.Visible = False

End Sub



Private Sub frameDateOptions_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  mvDate.Visible = False
End Sub

Private Sub mvDate_DateClick(ByVal DateClicked As Date)
   txtDate.Text = DateClicked
   mvDate.Visible = False
End Sub


Private Sub txtDate_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
   mvDate.Visible = True
End Sub
