/*
|============================================================================
|
|       Copyright (C) 2011 ProSoft Technology. All rights reserved.
|
|  File:             timer.c
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       Common Utility
|
|  Subsystem:        ProLinx
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      This file contains the definitions needed for simple timer processing.
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     10/19/2011 HYU      Created.
|============================================================================
*/
#ifndef TIMER_H_FILE
#define TIMER_H_FILE

#define MAX_NUM_TIMERS      10
#define SIMPLE_TIMER_NULL   (int)-1

typedef void (*timerProc) (int timer_num, void * p);


void    simple_timer_init     (void);
void    simple_timer_process  (long time_passed);
int     simple_timer_new      (void);
int     simple_timer_create   (long interval, timerProc proc, void * p);
void    simple_timer_free     (int timer_num);
void    simple_timer_reset    (int timer_num);
void    simple_timer_restart  (int timer_num, long newInterval);
void    simple_timer_start    (int timer_num);
void    simple_timer_stop     (int timer_num);
int     simple_timer_running  (int timer_num);

#endif
