#ifndef type_and_variables_h
#define type_and_variables_h

#include "ocxbpapi.h"
#include "tags.h"
#include "./../../ThingWorx-ldm-interface-lib/tw-ldm-interface-lib/inc/tw-ldm-interface-lib.h"

#define	TRUE	1
#define FALSE	0

//  the default timeout for controller communication is 1000 milli seconds
#define DEFAULT_OCX_TIMEOUT   1000

extern OCXHANDLE		OCX_Handle;
extern OCXHANDLE		OCX_Obj_Handle;
extern OCXHANDLE		Conn_Handle;
extern OCXCIPIDOBJ     ID_Obj;
extern volatile int	Backplane_Connected;
extern volatile int	Backplane_Connecting;
extern volatile int PLC_mode;

extern volatile int PLC_DB_Initialized;
extern OCXTAGDBHANDLE 	Tag_Db_Handle;

// number of symbols in controller data base
extern WORD			Number_Of_Symbols;

// controls exit from main program loop
extern volatile WORD			Done;

extern volatile int exit_code;

extern volatile const char* current_status;

void Display(char * display_string);
int open_backplane(void);
void close_backplane(void);
int open_tag_dbase(char * path_to_controller);
void close_tag_dbase(void);
void check_controller_status(char do_log, char verbose_log);
void print_rack_information(void);
void print_database_symbols(void);

int  get_tag_info(char * tag_name, OCXCIPTAGACCESS * tag_definition);

#endif