#ifndef NETHELPER_H_
#define NETHELPER_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <netinet/in.h>


/////////////////////////////////////////////////////////////////
// Definitions
/////////////////////////////////////////////////////////////////
#define NETHELPER_EXIT_FAILURE -1
#define NETHELPER_EXIT_SUCCESS  0

#define ENET_IF0_NAME "eth0"
#define ENET_IF1_NAME "eth1"


typedef struct
{
    char name[32];
    uint64_t rx;
    uint64_t rxp;
    uint64_t rx_drop;
    uint64_t rx_errs;
    uint64_t tx;
    uint64_t txp;
    uint64_t tx_drop;
    uint64_t tx_errs;
} IF_INFO;

/////////////////////////////////////////////////////////////////
// Function Prototypes
/////////////////////////////////////////////////////////////////
extern int getIPAddress(char *ifname, struct in_addr *ip);
extern int setIPAddress(char *ifname, struct in_addr *ip);
extern int setNetworkMask(char *ifname, struct in_addr *netMask);
extern int getNetworkMask(char *ifname, struct in_addr *netMask);
extern int removeDefaultGateway(char *ifname);
extern int addDefaultGateway(char *ifname,struct in_addr *gateway);
extern int getMACAddress(char *ifname, unsigned char buffer[6]);
extern int addBroadcastRoute(char *ifname);
extern int addMulticastRoute(char *ifname);
extern int ifdown(char *ifname);
extern int iface_up(char *ifname);
int getifconfig(char * devname, int * speed, int * duplex, int * autoneg);
int getifinfo(const char *iface, IF_INFO * ifinfo);
int getNameServers(char * name_server, char * name_server2);
int setNameServers(const char * name_server, const char * name_server2);
void gratuitous_arp_request( void );
void gratuitous_arp_request_interface( char * ifname );
unsigned long resolve_ip(const char *ip_addr);
unsigned long gethostip(char *ifname);

#ifdef __cplusplus
}
#endif
#endif /*NETHELPER_H_*/
