/*
|============================================================================
|
|       Copyright (C) 2011 ProSoft Technology. All rights reserved.
|
|  File:             PLXDef.h
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     8/20/2011 HYU              Created.
|           03/14/2012 HYU              Defined offsetof().
|============================================================================
*/
#ifndef _PLXDEF_H
#define _PLXDEF_H

#include <unistd.h>


#ifndef FALSE
#define FALSE     0
#endif

#ifndef TRUE
#define TRUE      1
#endif


#ifdef __cplusplus
#define NULL    0
#else
#define NULL    ((void *)0)
#endif


typedef int            BOOL;

/*
#ifndef BYTE_DEFINED
#define BYTE_DEFINED
typedef unsigned char  BYTE;
#endif

#ifndef WORD_DEFINED
#define WORD_DEFINED
typedef unsigned short WORD;
#endif

#ifndef DWORD_DEFINED
#define DWORD_DEFINED
typedef unsigned long  DWORD;
#endif
*/

#define PROTECT_SECTION
#define UNPROTECT_SECTION

#define MAX_REV_INFO   500

#define TM_ROLLOVER    1000000L

#ifndef stricmp
#define stricmp   strcasecmp
#endif

# ifndef strnicmp
#  define strnicmp(s1, s2, maxlen) strncasecmp(s1,s2,maxlen)
# endif

# ifndef delay
#  define delay(milliseconds)      usleep((unsigned long)milliseconds * 1000UL)
# endif

#ifndef offsetof
#define offsetof(s,m)   (size_t)&(((s *)0)->m)
#endif

//This function is not found in but is part of stdlib
extern void swab (__const void * __from, void * __to, unsigned int __n);

#endif
